/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.github.dockerjava.core.dockerfile.DockerfileStatement;
import com.google.common.collect.Iterators;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.NotNullSetter;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.VolumeMapper;
import com.intellij.docker.agent.fix.FixedCreateContainerCmdConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DockerAgentDeploymentImpl
extends DockerAgentApplicationBase
implements DockerAgentDeployment {
    private final DockerAgentDeploymentConfig myConfig;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final VolumeMapper myVolumeMapper;
    private String myImageId;

    public DockerAgentDeploymentImpl(DockerAgentContext context, DockerAgentDeploymentConfig config, CloudAgentLoggingHandler loggingHandler, DockerAgentPathMapper pathMapper) {
        super(context);
        this.myConfig = config;
        this.myLoggingHandler = loggingHandler;
        this.myVolumeMapper = new VolumeMapper(pathMapper);
    }

    public void deploy() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentSourceType sourceType = DockerAgentSourceType.valueOf((String)DockerAgentDeploymentImpl.this.myConfig.sourceType());
                new SingleDeployTask(sourceType).deploy();
                return null;
            }
        }.perform();
    }

    @Override
    protected Bind[] prepareBinds(Bind[] binds) {
        return this.myVolumeMapper.expandPath(binds);
    }

    private void buildImage() throws IOException, ApiTaskException {
        this.myLoggingHandler.println("Building image...");
        File file = this.myConfig.getFile();
        BuildImageCmd buildImageCmd = this.myConfig.isFileArchive() ? this.getClient().buildImageCmd((InputStream)new FileInputStream(file)) : ("Dockerfile".equals(file.getName()) ? this.getClient().buildImageCmd(new DockerfileFullFolder(file).parse().buildDockerFolderTar(file.getParentFile())) : this.getClient().buildImageCmd(file));
        String imageTag = this.myConfig.getImageTag();
        if (imageTag != null) {
            buildImageCmd.withTag(imageTag);
        }
        this.execBuildImage(buildImageCmd);
    }

    private void execBuildImage(BuildImageCmd buildImageCmd) throws ApiTaskException {
        BuildCallback buildCallback = (BuildCallback)buildImageCmd.exec((ResultCallback)new BuildCallback());
        buildCallback.waitFor();
        if (this.myImageId == null) {
            throw new ApiTaskException("Can't retrieve image ID from build stream");
        }
    }

    @Override
    public void showLog(CloudAgentLoggingHandler loggingHandler) {
        super.showLog(this.myLoggingHandler);
    }

    @Override
    public void inspect2log(CloudAgentLoggingHandler loggingHandler) {
        super.inspect2log(this.myLoggingHandler);
    }

    @Override
    public void showProcesses(CloudAgentLoggingHandler loggingHandler) {
        super.showProcesses(this.myLoggingHandler);
    }

    @Override
    public void attach(CloudAgentLoggingHandler loggingHandler) {
        super.attach(this.myLoggingHandler);
    }

    @Override
    public OngoingProcess exec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) {
        return super.exec(this.myLoggingHandler, command, logName);
    }

    public String getContainerName() {
        return null;
    }

    public String getImageId() {
        return this.myImageId;
    }

    public String[] getImageRepoTags() {
        return null;
    }

    public String[] getContainerNames() {
        return null;
    }

    public String getImageParentId() {
        return null;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public String getContainerStatus() {
        return null;
    }

    private class SingleDeployTask
    extends DeployTask {
        private CreateContainerCmdConfig myContainerCmdConfig;
        private DockerAgentSourceType mySourceType;

        public SingleDeployTask(DockerAgentSourceType sourceType) {
            this.mySourceType = sourceType;
        }

        @Override
        protected String doPrepareDeploy() throws IOException, ApiTaskException {
            CreateContainerCmdConfig cmdConfig;
            String configJSON = DockerAgentDeploymentImpl.this.myConfig.getJSON();
            if (configJSON == null) {
                cmdConfig = new CreateContainerCmdConfig();
            } else {
                cmdConfig = (CreateContainerCmdConfig)((Object)new ObjectMapper().readValue(new File(configJSON), CreateContainerCmdConfig.class));
                FixedCreateContainerCmdConfig fixedCmdConfig = (FixedCreateContainerCmdConfig)((Object)new ObjectMapper().readValue(new File(configJSON), FixedCreateContainerCmdConfig.class));
                new NotNullSetter<Bind[]>(){

                    @Override
                    protected void doSet(Bind[] value) {
                        cmdConfig.withBinds(value);
                    }
                }.set((T[])new Bind[][]{fixedCmdConfig.getBinds()});
                new NotNullSetter<String>(){

                    @Override
                    protected void doSet(String value) {
                        cmdConfig.withContainerIDFile(value);
                    }
                }.set(fixedCmdConfig.getContainerIDFile());
            }
            this.myContainerCmdConfig = cmdConfig;
            if (this.mySourceType == DockerAgentSourceType.IMAGE) {
                DockerAgentDeploymentImpl.this.myImageId = DockerAgentDeploymentImpl.this.myConfig.getImageTag();
            } else {
                DockerAgentDeploymentImpl.this.buildImage();
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Creating container...");
            return DockerAgentDeploymentImpl.this.myConfig.getContainerName();
        }

        @Override
        protected CreateContainerCmdConfig getContainerCmdConfig() {
            return this.myContainerCmdConfig;
        }

        @Override
        protected DockerAgentContainerConfigImpl getPriorityConfig() {
            return new DockerAgentContainerConfigImpl((DockerAgentContainerConfig)DockerAgentDeploymentImpl.this.myConfig);
        }

        @Override
        protected void setContainerId(String containerId) {
            DockerAgentDeploymentImpl.this.setContainerId(containerId);
        }
    }

    private abstract class DeployTask {
        private DeployTask() {
        }

        public void deploy() throws IOException, ApiTaskException {
            String containerName = this.doPrepareDeploy();
            if (DockerAgentDeploymentImpl.this.myConfig.isBuildImageOnly()) {
                return;
            }
            String containerMessageSuffix = containerName == null ? "" : "'" + containerName + "'";
            CreateContainerCmd createContainerCmd = DockerAgentDeploymentImpl.this.getClient().createContainerCmd(DockerAgentDeploymentImpl.this.myImageId);
            if (containerName != null) {
                for (Container container : (List)DockerAgentDeploymentImpl.this.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()) {
                    String[] containerNames = container.getNames();
                    if (containerNames == null || !Arrays.asList(containerNames).contains("/" + containerName)) continue;
                    DockerAgentDeploymentImpl.this.getClient().removeContainerCmd(container.getId()).withForce(Boolean.valueOf(true)).exec();
                    break;
                }
                createContainerCmd.withName(containerName);
            }
            CreateContainerCmdConfig cmdConfig = this.getContainerCmdConfig();
            DockerAgentDeploymentImpl.this.setupContainerConfig(createContainerCmd, cmdConfig, this.getPriorityConfig());
            if (DockerAgentDeploymentImpl.this.myLoggingHandler.isTtySupported()) {
                createContainerCmd.withTty(Boolean.valueOf(true));
            }
            CreateContainerResponse createContainerResponse = createContainerCmd.exec();
            String containerId = createContainerResponse.getId();
            this.setContainerId(containerId);
            String[] warnings = createContainerResponse.getWarnings();
            if (warnings != null) {
                for (String warning : warnings) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println("Warning: " + warning);
                }
            }
            if (DockerAgentDeploymentImpl.this.myConfig.isCreateContainerOnly()) {
                return;
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Container Id: " + containerId);
            if (cmdConfig.isAttachStdin().booleanValue() && cmdConfig.isStdinOpen().booleanValue()) {
                DockerAgentDeploymentImpl.this.myLoggingHandler.println("Attaching to container " + containerMessageSuffix + "...");
                DockerAgentDeploymentImpl.this.doAttach(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            } else {
                DockerAgentDeploymentImpl.this.doShowLog(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Starting container " + containerMessageSuffix);
            StartContainerCmd startContainerCmd = DockerAgentDeploymentImpl.this.getClient().startContainerCmd(containerId);
            startContainerCmd.exec();
        }

        protected void setContainerId(String containerId) {
        }

        protected abstract String doPrepareDeploy() throws IOException, ApiTaskException;

        protected abstract CreateContainerCmdConfig getContainerCmdConfig();

        protected abstract DockerAgentContainerConfigImpl getPriorityConfig();
    }

    private static class DockerfileFullFolder
    extends Dockerfile {
        public DockerfileFullFolder(File dockerFile) {
            super(dockerFile, dockerFile.getParentFile());
        }

        public Iterable<DockerfileStatement> getStatements() throws IOException {
            final Iterable statements = super.getStatements();
            return new Iterable<DockerfileStatement>(){

                @Override
                public Iterator<DockerfileStatement> iterator() {
                    return Iterators.concat(statements.iterator(), Collections.singletonList(DockerfileStatement.Add.create((String)"ADD . .").get()).iterator());
                }
            };
        }
    }

    private class BuildCallback
    implements ResultCallback<BuildResponseItem> {
        private final Object myMutex = new Object();
        private String myError;
        private boolean myClosed = false;

        private BuildCallback() {
        }

        public void onStart(Closeable closeable) {
        }

        public void onNext(BuildResponseItem item) {
            String progress;
            String imageId = item.getImageId();
            if (imageId != null) {
                DockerAgentDeploymentImpl.this.myImageId = imageId;
            }
            String error = item.getError();
            String stream = item.getStream();
            String status = item.getStatus();
            if (error != null) {
                this.myError = error;
                String errorMessage = error;
                ResponseItem.ErrorDetail errorDetail = item.getErrorDetail();
                if (errorDetail != null) {
                    errorMessage = errorDetail.toString();
                }
                DockerAgentDeploymentImpl.this.myLoggingHandler.println("Error: " + errorMessage);
            }
            if (stream != null) {
                DockerAgentDeploymentImpl.this.myLoggingHandler.println(stream);
            }
            StringBuilder statusLine = new StringBuilder();
            if (status != null) {
                statusLine.append("Status: ");
                statusLine.append(status);
            }
            if ((progress = item.getProgress()) != null) {
                statusLine.append(" Progress: ");
                statusLine.append(progress);
            }
            if (statusLine.length() != 0) {
                DockerAgentDeploymentImpl.this.myLoggingHandler.println(statusLine.toString());
            }
        }

        public void onError(Throwable throwable) {
            this.myError = throwable.getMessage();
            this.doClose();
        }

        public void onComplete() {
            this.doClose();
        }

        public void close() throws IOException {
            this.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClose() {
            Object object = this.myMutex;
            synchronized (object) {
                this.myClosed = true;
                this.myMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() throws ApiTaskException {
            Object object = this.myMutex;
            synchronized (object) {
                try {
                    while (!this.myClosed) {
                        this.myMutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    DockerAgentDeploymentImpl.this.getLogger().debugEx((Exception)e);
                }
            }
            if (this.myError != null) {
                throw new ApiTaskException(this.myError);
            }
        }
    }
}

