/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.OngoingProcessBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PullImageResultCallbackImpl
extends ResultCallbackTemplate<PullImageResultCallbackImpl, PullResponseItem>
implements OngoingProcess {
    private final DockerAgentProgressCallback myAgentCallback;
    private static final String DOWNLOADING_STATUS = "Downloading";
    private static final String DOWNLOAD_COMPLETE_STATUS = "Download complete";
    private static final String EXTRACTING_STATUS = "Extracting";
    private static final String PULL_COMPLETE_STATUS = "Pull complete";
    private final Map<ProgressKey, ProgressInfo> myDownloads = new ConcurrentHashMap<ProgressKey, ProgressInfo>();
    private final Map<ProgressKey, ProgressInfo> myExtractions = new ConcurrentHashMap<ProgressKey, ProgressInfo>();
    private final OngoingProcess myOngoingProcessDelegate;
    private final CloudAgentLogger myLogger;
    private String mySuccessMessage;
    private String myErrorMessage;

    public PullImageResultCallbackImpl(DockerAgentProgressCallback callback, CloudAgentLogger logger) {
        this.myAgentCallback = callback;
        this.myOngoingProcessDelegate = new OngoingProcessBase(logger){

            public void cancel() {
                new ApiTaskBase(this.getErrorHandler()){

                    @Override
                    protected Object doPerform() throws IOException {
                        PullImageResultCallbackImpl.this.mySuccessMessage = "Pull cancelled";
                        PullImageResultCallbackImpl.this.close();
                        return null;
                    }
                }.perform();
            }

            public void await() {
                new ApiTaskBase(this.getErrorHandler()){

                    @Override
                    protected Object doPerform() throws InterruptedException {
                        PullImageResultCallbackImpl.this.awaitCompletion();
                        return null;
                    }
                }.perform();
            }
        };
        this.myLogger = logger;
    }

    public void onNext(PullResponseItem item) {
        if (item.isPullSuccessIndicated()) {
            this.mySuccessMessage = item.getStatus();
        }
        if (item.isErrorIndicated()) {
            this.myErrorMessage = item.getErrorDetail().getMessage();
        }
        String status = item.getStatus();
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        String id = item.getId();
        if (id != null && status != null) {
            ProgressKey progressKey = new ProgressKey(status, id);
            if (DOWNLOADING_STATUS.equals(status)) {
                this.updateProgress(progressKey, progressDetail, this.myDownloads);
            } else if (DOWNLOAD_COMPLETE_STATUS.equals(status)) {
                PullImageResultCallbackImpl.completeProgress(progressKey, this.myDownloads);
            } else if (EXTRACTING_STATUS.equals(status)) {
                this.updateProgress(progressKey, progressDetail, this.myExtractions);
            } else if (PULL_COMPLETE_STATUS.equals(status)) {
                PullImageResultCallbackImpl.completeProgress(progressKey, this.myDownloads);
                PullImageResultCallbackImpl.completeProgress(progressKey, this.myExtractions);
            }
        }
        this.updateIndicator(item);
    }

    public void onError(Throwable throwable) {
        this.myErrorMessage = throwable.toString();
        this.myLogger.debugEx(new Exception(throwable));
        super.onError(throwable);
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.myErrorMessage != null) {
                this.myAgentCallback.failed(this.myErrorMessage);
            } else {
                this.myAgentCallback.succeeded(this.mySuccessMessage);
            }
        }
    }

    public void cancel() {
        this.myOngoingProcessDelegate.cancel();
    }

    public void await() {
        this.myOngoingProcessDelegate.await();
    }

    public void setErrorHandler(CloudAgentErrorHandler errorHandler) {
        this.myOngoingProcessDelegate.setErrorHandler(errorHandler);
    }

    private static void completeProgress(ProgressKey progressKey, Map<ProgressKey, ProgressInfo> map) {
        ProgressInfo previousProgressInfo = map.get(progressKey);
        if (previousProgressInfo != null) {
            map.put(progressKey, ProgressInfo.complete(previousProgressInfo));
        }
    }

    private void updateProgress(ProgressKey progressKey, ResponseItem.ProgressDetail progressDetail, Map<ProgressKey, ProgressInfo> map) {
        if (progressDetail != null) {
            long current = progressDetail.getCurrent();
            long total = progressDetail.getTotal();
            map.put(progressKey, new ProgressInfo(current, total));
        }
    }

    private void updateIndicator(PullResponseItem item) {
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        if (progressDetail != null) {
            ProgressInfo downloadProgress = PullImageResultCallbackImpl.computeOverallProgress(this.myDownloads);
            ProgressInfo extractProgress = PullImageResultCallbackImpl.computeOverallProgress(this.myExtractions);
            if (!(downloadProgress == null || downloadProgress.isCompleted() && extractProgress != null)) {
                this.myAgentCallback.step(item.getStatus(), downloadProgress.getCurrent(), downloadProgress.getTotal());
            } else if (extractProgress != null && !extractProgress.isCompleted()) {
                this.myAgentCallback.step(item.getStatus(), extractProgress.getCurrent(), extractProgress.getTotal());
            }
        }
    }

    private static ProgressInfo computeOverallProgress(Map<ProgressKey, ProgressInfo> map) {
        int current = 0;
        int total = 0;
        for (ProgressInfo info : map.values()) {
            current = (int)((long)current + info.getCurrent());
            total = (int)((long)total + info.getTotal());
        }
        return total > 0 ? new ProgressInfo(current, total) : null;
    }

    private static class ProgressInfo {
        private final long myCurrent;
        private final long myTotal;

        private ProgressInfo(long current, long total) {
            this.myCurrent = current;
            this.myTotal = total;
        }

        public long getCurrent() {
            return this.myCurrent;
        }

        public long getTotal() {
            return this.myTotal;
        }

        public double getFraction() {
            return (double)this.myCurrent / (double)this.myTotal;
        }

        public boolean isCompleted() {
            return this.myCurrent == this.myTotal;
        }

        public static ProgressInfo complete(ProgressInfo progressInfo) {
            return new ProgressInfo(progressInfo.getTotal(), progressInfo.getTotal());
        }
    }

    private static class ProgressKey {
        private final String myStatus;
        private final String myId;

        private ProgressKey(String status, String id) {
            this.myStatus = status;
            this.myId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProgressKey key = (ProgressKey)o;
            if (!this.myStatus.equals(key.myStatus)) {
                return false;
            }
            return this.myId.equals(key.myId);
        }

        public int hashCode() {
            int result = this.myStatus.hashCode();
            result = 31 * result + this.myId.hashCode();
            return result;
        }
    }
}

