/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.netty;

import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.handler.HttpRequestProvider;
import com.github.dockerjava.netty.handler.HttpResponseHandler;
import com.intellij.docker.agent.netty.AsyncResultCallbackCopy;
import com.intellij.docker.agent.netty.HttpResponseStreamHandlerFixed;
import com.intellij.docker.agent.netty.InvocationBuilderCopy;
import com.intellij.docker.agent.netty.JsonObjectDecoderFixed;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.DuplexChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

class InvocationBuilderFixed
extends InvocationBuilderCopy {
    public InvocationBuilderFixed(ChannelProvider provider, String resource) {
        super(provider, resource);
    }

    @Override
    public InputStream post(Object entity) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        AsyncResultCallbackCopy<InputStream> callback = new AsyncResultCallbackCopy<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        HttpResponseStreamHandlerFixed streamHandler = new HttpResponseStreamHandlerFixed(callback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, (Channel)channel);
        try {
            return IOUtils.toBufferedInputStream((InputStream)callback.awaitResult());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream get() {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        AsyncResultCallbackCopy<InputStream> resultCallback = new AsyncResultCallbackCopy<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpResponseStreamHandlerFixed streamHandler = new HttpResponseStreamHandlerFixed(resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, (Channel)channel);
        return resultCallback.awaitResult();
    }

    @Override
    protected void sendRequest(HttpRequestProvider requestProvider, Channel channel) {
        ChannelFuture channelFuture = channel.writeAndFlush((Object)requestProvider.getHttpRequest(this.getResource()));
        channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    @Override
    protected ByteToMessageDecoder createJsonObjectDecoder() {
        return new JsonObjectDecoderFixed();
    }
}

