/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.javascript.debugger.JSDebuggerEditorsProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceFileValueHint
extends AbstractValueHint {
    private final String myExpression;
    private final String myValueName;
    private final XSourcePosition myExpressionPosition;
    private XDebuggerEvaluator myEvaluator;
    private static final Logger LOG = Logger.getInstance(SourceFileValueHint.class);

    public SourceFileValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, TextRange textRange, @NotNull XDebuggerEvaluator evaluator, @NotNull ExpressionInfo expressionInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/SourceFileValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/debugger/SourceFileValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/javascript/trace/debugger/SourceFileValueHint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/debugger/SourceFileValueHint", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/javascript/trace/debugger/SourceFileValueHint", "<init>"));
        }
        if (expressionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfo", "com/intellij/javascript/trace/debugger/SourceFileValueHint", "<init>"));
        }
        super(project, editor, point, type, textRange);
        this.myEvaluator = evaluator;
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText((ExpressionInfo)expressionInfo, (Document)editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText((ExpressionInfo)expressionInfo, (Document)editor.getDocument());
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file != null ? XDebuggerUtil.getInstance().createPositionByOffset(file, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    protected boolean canShowHint() {
        return true;
    }

    protected void evaluateAndShowHint() {
        this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/trace/debugger/SourceFileValueHint$1", "evaluated"));
                }
                result.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                    private XFullValueEvaluator myFullValueEvaluator;

                    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                        if (valuePresenter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/javascript/trace/debugger/SourceFileValueHint$1$1", "applyPresentation"));
                        }
                        if (SourceFileValueHint.this.isHintHidden()) {
                            return;
                        }
                        SimpleColoredText text = new SimpleColoredText();
                        text.append(SourceFileValueHint.this.myValueName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        XValueNodeImpl.buildText((XValuePresentation)valuePresenter, (ColoredTextContainer)text);
                        if (!hasChildren) {
                            SimpleColoredComponent component = HintUtil.createInformationComponent();
                            text.appendToComponent((ColoredTextContainer)component);
                            if (this.myFullValueEvaluator != null) {
                                component.append(this.myFullValueEvaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, (Object)new Consumer<MouseEvent>(){

                                    public void consume(MouseEvent event) {
                                        DebuggerUIUtil.showValuePopup((XFullValueEvaluator)myFullValueEvaluator, (MouseEvent)event, (Project)SourceFileValueHint.this.getProject(), (Editor)SourceFileValueHint.this.getEditor());
                                    }
                                });
                                LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)component);
                            }
                            SourceFileValueHint.this.showHint((JComponent)component);
                        } else if (SourceFileValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                            SourceFileValueHint.this.showTree(result);
                        } else {
                            JComponent component = SourceFileValueHint.this.createExpandableHintComponent(text, () -> {
                                if (result == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/trace/debugger/SourceFileValueHint$1$1", "lambda$applyPresentation$0"));
                                }
                                SourceFileValueHint.this.showTree(result);
                            });
                            SourceFileValueHint.this.showHint(component);
                        }
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/javascript/trace/debugger/SourceFileValueHint$1$1", "setFullValueEvaluator"));
                        }
                        this.myFullValueEvaluator = fullValueEvaluator;
                    }

                    public boolean isObsolete() {
                        return SourceFileValueHint.this.isHintHidden();
                    }
                }, XValuePlace.TOOLTIP);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/javascript/trace/debugger/SourceFileValueHint$1", "errorOccurred"));
                }
                LOG.debug("Cannot evaluate '" + SourceFileValueHint.this.myExpression + "':" + errorMessage);
            }
        }, this.myExpressionPosition);
    }

    private void showTree(XValue value) {
        XDebuggerTreeCreator creator = new XDebuggerTreeCreator(this.getProject(), (XDebuggerEditorsProvider)new JSDebuggerEditorsProvider(), this.myExpressionPosition, null);
        this.showTreePopup((DebuggerTreeCreator)creator, Pair.create((Object)value, (Object)this.myValueName));
    }
}

