/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.javascript.trace.execution.context.TraceFileValueTreeCreator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceFileValueHint
extends AbstractValueHint {
    private XNamedValue myValue;

    public TraceFileValueHint(Project project, Editor editor, Point point, ValueHintType type, TextRange textRange, XNamedValue value) {
        super(project, editor, point, type, textRange);
        this.myValue = value;
    }

    protected boolean canShowHint() {
        return true;
    }

    protected void evaluateAndShowHint() {
        this.myValue.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){

            public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                if (valuePresenter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/javascript/trace/debugger/TraceFileValueHint$1", "applyPresentation"));
                }
                if (TraceFileValueHint.this.isHintHidden()) {
                    return;
                }
                SimpleColoredText text = new SimpleColoredText();
                text.append(TraceFileValueHint.this.myValue.getName(), XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                XValueNodeImpl.buildText((XValuePresentation)valuePresenter, (ColoredTextContainer)text);
                if (!hasChildren) {
                    TraceFileValueHint.this.showHint(HintUtil.createInformationLabel((SimpleColoredText)text));
                } else {
                    JComponent component = TraceFileValueHint.this.createExpandableHintComponent(text, () -> TraceFileValueHint.this.showTree(TraceFileValueHint.this.myValue));
                    TraceFileValueHint.this.showHint(component);
                }
            }

            public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                if (fullValueEvaluator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/javascript/trace/debugger/TraceFileValueHint$1", "setFullValueEvaluator"));
                }
            }

            public boolean isObsolete() {
                return false;
            }
        }, XValuePlace.TOOLTIP);
    }

    private void showTree(XNamedValue value) {
        this.showTreePopup(new TraceFileValueTreeCreator(this.getProject()), value);
    }
}

