/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger.values;

import com.intellij.javascript.trace.debugger.values.TraceObjectWithLength;
import com.intellij.javascript.trace.debugger.values.TraceValueManager;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ValueType;

public class TraceObject
extends TraceObjectWithLength {
    private final TraceValueManager myValueManager;
    private final String myExpression;
    @Nullable
    private final String myClassName;
    private final ThreeState myHasProps;
    @Nullable
    private final String myValue;
    private final VariablesHost<TraceValueManager> childrenManager;

    @NotNull
    protected VariablesHost<TraceValueManager> getChildrenManager() {
        VariablesHost<TraceValueManager> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceObject", "getChildrenManager"));
        }
        return variablesHost;
    }

    public TraceObject(@NotNull ValueType type, @NotNull TraceValueManager valueManager, @NotNull String expression, @Nullable String className, @NotNull ThreeState hasProps, @Nullable String value, int length) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/debugger/values/TraceObject", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/trace/debugger/values/TraceObject", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/values/TraceObject", "<init>"));
        }
        if (hasProps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasProps", "com/intellij/javascript/trace/debugger/values/TraceObject", "<init>"));
        }
        super(type, length);
        this.myValueManager = valueManager;
        this.myExpression = expression;
        this.myClassName = className;
        this.myHasProps = hasProps;
        this.myValue = value;
        this.childrenManager = new VariablesHost<TraceValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                AsyncPromise result = new AsyncPromise();
                TraceObject.this.myValueManager.loadProperties(TraceObject.this.myExpression, (AsyncPromise<List<Variable>>)result);
                AsyncPromise asyncPromise = result;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceObject$1", "load"));
                }
                return asyncPromise;
            }
        };
    }

    @NotNull
    public Promise<Void> getIndexedProperties(int from, int to, int bucketThreshold, @NotNull IndexedVariablesConsumer consumer, @Nullable ValueType componentType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/trace/debugger/values/TraceObject", "getIndexedProperties"));
        }
        Promise<ExpressionEvaluationResult> promise = this.myValueManager.getIndexedProperties(this.myExpression, from, to, bucketThreshold, consumer);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceObject", "getIndexedProperties"));
        }
        return promise;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = this.myHasProps;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceObject", "hasProperties"));
        }
        return threeState;
    }

    @Nullable
    public String getValueString() {
        return this.myValue;
    }
}

