/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticElementVisitor;
import com.intellij.javascript.trace.execution.code.StaticUnknownElement;
import org.jetbrains.annotations.NotNull;

public class RuntimeStatement
implements CodeElement {
    private Integer myId;
    private StaticCodeElement myElement;

    public RuntimeStatement(StaticCodeElement element) {
        this.myElement = element;
    }

    public RuntimeStatement(StaticUnknownElement element, int id) {
        this.myElement = element;
        this.myId = id;
    }

    @Override
    @NotNull
    public String getFile() {
        String string = this.myElement.getFile();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/RuntimeStatement", "getFile"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFunc() {
        String string = this.myElement.getFunc();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/RuntimeStatement", "getFunc"));
        }
        return string;
    }

    @Override
    @NotNull
    public CodeRange getCodeRange() {
        CodeRange codeRange = this.myElement.getCodeRange();
        if (codeRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/RuntimeStatement", "getCodeRange"));
        }
        return codeRange;
    }

    public boolean isLoaded() {
        return !(this.myElement instanceof StaticUnknownElement);
    }

    public int getId() {
        return this.myId;
    }

    public void accept(@NotNull StaticElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/javascript/trace/execution/common/RuntimeStatement", "accept"));
        }
        this.myElement.accept(visitor);
    }

    public void update(StaticCodeElement codeElement) {
        this.myElement = codeElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeStatement statement = (RuntimeStatement)o;
        if (!this.getCodeRange().equals(statement.getCodeRange())) {
            return false;
        }
        if (!this.getFile().equals(statement.getFile())) {
            return false;
        }
        return this.getFunc().equals(statement.getFunc());
    }

    public int hashCode() {
        int result = this.getFile().hashCode();
        result = 31 * result + this.getFunc().hashCode();
        result = 31 * result + this.getCodeRange().hashCode();
        return result;
    }

    public StaticCodeElement getCodeElement() {
        return this.myElement;
    }
}

