/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.context;

import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.context.EventValue;
import com.intellij.javascript.trace.execution.context.FunctionSummaryValue;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import org.jetbrains.annotations.NotNull;

public class ContextTreeRoot
extends XValueGroup {
    private RuntimeFunctionScope myStackFrame;
    private StackFrameContext myContext;

    protected ContextTreeRoot(@NotNull StackFrameContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/context/ContextTreeRoot", "<init>"));
        }
        super("");
        this.myContext = context;
        this.myStackFrame = context.getStackFrame();
    }

    public boolean isAutoExpand() {
        return true;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/context/ContextTreeRoot", "computeChildren"));
        }
        XValueChildrenList children = new XValueChildrenList();
        this.computeEventContext(children);
        this.computeStackFrameContext(children);
        node.addChildren(children, true);
    }

    private void computeEventContext(XValueChildrenList children) {
        children.add((XNamedValue)new EventValue(this.myContext));
    }

    private void computeStackFrameContext(XValueChildrenList children) {
        if (this.myStackFrame != null) {
            children.add((XNamedValue)new FunctionSummaryValue(this.myContext));
        }
    }
}

