/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.context;

import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.stack.StackNode;
import javax.swing.Icon;

public class StackFrameContext {
    private final RuntimeFunctionScope myScope;
    private final Icon myEventIcon;
    private final String myEventName;
    private final String[] myEventFiles;
    private final Icon myStackFrameIcon;
    private final String myStackFrameName;

    public static StackFrameContext create(EventNode eventNode, StackNode stackNode) {
        return new StackFrameContext(stackNode.getScope(), eventNode.getIcon(), eventNode.getName(), eventNode.getEvent().getFiles(), stackNode.getIcon(), stackNode.getName());
    }

    public static StackFrameContext create(StackFrameContext context, StackNode stackNode) {
        return new StackFrameContext(stackNode.getScope(), context.getEventIcon(), context.getEventName(), context.getEventFiles(), stackNode.getIcon(), stackNode.getName());
    }

    private StackFrameContext(RuntimeFunctionScope scope, Icon eventIcon, String eventName, String[] eventFiles, Icon stackFrameIcon, String stackFrameName) {
        this.myScope = scope;
        this.myEventIcon = eventIcon;
        this.myEventName = eventName;
        this.myEventFiles = eventFiles;
        this.myStackFrameIcon = stackFrameIcon;
        this.myStackFrameName = stackFrameName;
    }

    public RuntimeFunctionScope getStackFrame() {
        return this.myScope;
    }

    public Icon getEventIcon() {
        return this.myEventIcon;
    }

    public String getEventName() {
        return this.myEventName;
    }

    public String[] getEventFiles() {
        return this.myEventFiles;
    }

    public Icon getStackFrameIcon() {
        return this.myStackFrameIcon;
    }

    public String getStackFrameName() {
        return this.myStackFrameName;
    }
}

