/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.evaluation;

import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionEvaluationRequest {
    private PsiElement myContext;
    private String myExpression;
    private boolean myIncludeProperties;
    private boolean myAutocomplete;
    private boolean myOnlyValidIdentifierNames;
    private boolean myGetFullString;
    @Nullable
    private Range<Integer> myPropertyRange;
    @Nullable
    private Integer myThreshold;
    private int functionId;
    private int totalNumberOfFunctions;
    private String file;
    private long myTimeout;

    private ExpressionEvaluationRequest(@NotNull PsiElement context, @NotNull String expression, boolean includeProperties, boolean autocomplete, boolean onlyValidIdentifierNames, boolean getFullString, @Nullable Range<Integer> propertyRange, @Nullable Integer threshold) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "<init>"));
        }
        this.myTimeout = 2000L;
        this.myContext = context;
        this.myExpression = expression;
        this.myIncludeProperties = includeProperties;
        this.myAutocomplete = autocomplete;
        this.myOnlyValidIdentifierNames = onlyValidIdentifierNames;
        this.myGetFullString = getFullString;
        this.myPropertyRange = propertyRange;
        this.myThreshold = threshold;
    }

    public static ExpressionEvaluationRequest createAutocompletePropertiesRequest(@NotNull PsiElement context, @NotNull String expression, boolean onlyValidIdentifierNames) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createAutocompletePropertiesRequest"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createAutocompletePropertiesRequest"));
        }
        return new ExpressionEvaluationRequest(context, expression, true, true, onlyValidIdentifierNames, false, null, null).setTimeout(400L);
    }

    public static ExpressionEvaluationRequest createPropertiesRequest(@NotNull PsiElement context, @NotNull String expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createPropertiesRequest"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createPropertiesRequest"));
        }
        return new ExpressionEvaluationRequest(context, expression, true, false, false, false, null, null);
    }

    public static ExpressionEvaluationRequest createPropertiesRequest(@NotNull PsiElement context, @NotNull String expression, Range<Integer> propertyRange, Integer threshold) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createPropertiesRequest"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createPropertiesRequest"));
        }
        return new ExpressionEvaluationRequest(context, expression, true, false, false, false, propertyRange, threshold);
    }

    public static ExpressionEvaluationRequest createObjectRequest(@NotNull PsiElement context, @NotNull String expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createObjectRequest"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createObjectRequest"));
        }
        return new ExpressionEvaluationRequest(context, expression, false, false, false, false, null, null);
    }

    public static ExpressionEvaluationRequest createFullStringRequest(@NotNull PsiElement context, @NotNull String expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createFullStringRequest"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "createFullStringRequest"));
        }
        return new ExpressionEvaluationRequest(context, expression, false, false, false, true, null, null);
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public String getExpression() {
        return this.myExpression;
    }

    public boolean needToIncludeProperties() {
        return this.myIncludeProperties;
    }

    public int getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(int functionId) {
        this.functionId = functionId;
    }

    public int getTotalNumberOfFunctions() {
        return this.totalNumberOfFunctions;
    }

    public void setTotalNumberOfFunctions(int totalNumberOfFunctions) {
        this.totalNumberOfFunctions = totalNumberOfFunctions;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/evaluation/ExpressionEvaluationRequest", "setFile"));
        }
        this.file = file;
    }

    public boolean needToGetFullString() {
        return this.myGetFullString;
    }

    @Nullable
    public Range<Integer> getPropertyRange() {
        return this.myPropertyRange;
    }

    @Nullable
    public Integer getThreshold() {
        return this.myThreshold;
    }

    public boolean isForAutocomplete() {
        return this.myAutocomplete;
    }

    public long getTimeout() {
        return this.myTimeout;
    }

    public boolean includeOnlyValidIdentifierNames() {
        return this.myOnlyValidIdentifierNames;
    }

    private ExpressionEvaluationRequest setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }
}

