/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.StackEntry;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.lang.javascript.ui.FileColor;
import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashSet;
import icons.SpyJSIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventNode
extends EventTreeNode {
    private EventTreeNode myParent;
    private EventMetadataExtended myEvent;
    private String myName = "";
    private Double myExecutionTime;
    private String mySummary;
    private static final int MAX_FILES = 30;
    private static final int MAX_MODULES = 30;

    public EventNode(EventTreeNode parent, EventMetadataExtended event) {
        super(parent);
        this.myParent = parent;
        this.myEvent = event;
        this.setName();
        this.setExecutionTime();
        this.setSummary();
        if (this.myEvent.isGlobalScope()) {
            this.setIcon(FileColor.getIcon((String)this.myEvent.getGlobalScopeFile()));
        } else if (event.getFirstEntry().getIsFromSetInterval().booleanValue()) {
            this.setIcon(SpyJSIcons.SpecialEventRecurrence);
        } else if (event.getFirstEntry().getIsFromSetTimeout().booleanValue() || event.getFirstEntry().getIsFromSetImmediate().booleanValue()) {
            this.setIcon(SpyJSIcons.SpecialEvent);
        } else {
            this.setIcon(SpyJSIcons.Event);
        }
        this.setText(this.getPresentation());
        this.setTooltip(this.getPresentation());
    }

    private void setSummary() {
        StringBuilder files = new StringBuilder();
        StringBuilder modules = new StringBuilder();
        HashSet uniqueModules = new HashSet();
        HashSet uniqueFiles = new HashSet();
        for (String fileUrl : this.myEvent.getFiles()) {
            String module = NodeModuleNamesUtil.getModule((String)fileUrl);
            if (StringUtil.isEmpty((String)module)) {
                String shortFileName = Utils.getShortFileName(fileUrl);
                if (uniqueFiles.contains((Object)shortFileName) || uniqueModules.size() > 30) continue;
                files.append(String.format(TraceBundle.message("console.trace.events.eventTooltipTemplate.fileEntryTemplate", new Object[0]), "&nbsp;&nbsp;&nbsp;", uniqueFiles.size() == 30 ? "..." : shortFileName));
                uniqueFiles.add((Object)shortFileName);
                continue;
            }
            if (uniqueModules.contains((Object)module) || uniqueModules.size() > 30) continue;
            modules.append(String.format(TraceBundle.message("console.trace.events.eventTooltipTemplate.fileEntryTemplate", new Object[0]), "&nbsp;&nbsp;&nbsp;", uniqueModules.size() == 30 ? "..." : module));
            uniqueModules.add((Object)module);
        }
        Double time = this.getExecutionTime();
        String allFiles = files.toString();
        String allModules = modules.toString();
        this.mySummary = String.format(TraceBundle.message("console.trace.events.eventTooltipTemplate", new Object[0]), this.getName(), time != null ? Utils.formatExecutionTime(time) : TraceBundle.message("console.trace.unknown", new Object[0]), StringUtil.isEmpty((String)allFiles) ? "" : String.format(TraceBundle.message("console.trace.events.eventTooltipTemplateFilesPart", new Object[0]), allFiles), StringUtil.isEmpty((String)allModules) ? "" : String.format(TraceBundle.message("console.trace.events.eventTooltipTemplateModulesPart", new Object[0]), allModules));
    }

    private void setExecutionTime() {
        double lastStamp = this.myEvent.getLastEntry().getTimeStamp();
        double firstStamp = this.myEvent.getFirstEntry().getTimeStamp();
        if (firstStamp > 0.0 && lastStamp > 0.0) {
            this.myExecutionTime = lastStamp - firstStamp;
        }
    }

    private void setName() {
        StackEntry firstEntry = this.myEvent.getFirstEntry();
        String eventName = firstEntry.getEventName();
        this.myName = firstEntry.getIsFromSetTimeout() != false ? TraceBundle.message("console.trace.events.timeout", new Object[0]) : (firstEntry.getIsFromSetInterval() != false ? TraceBundle.message("console.trace.events.interval", new Object[0]) : (firstEntry.getIsFromSetImmediate() != false ? TraceBundle.message("console.trace.events.immediate", new Object[0]) : (eventName != null ? eventName : (!this.myEvent.isGlobalScope() ? TraceBundle.message("console.trace.events.unknown", new Object[0]) : String.format(TraceBundle.message("console.trace.events.global", new Object[0]), Utils.getShortFileName(this.myEvent.getGlobalScopeFile()))))));
    }

    @Override
    protected void setText(PresentationData presentation) {
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Double time = this.getExecutionTime();
        presentation.addText(TraceBundle.message("console.trace.doubleSpace", new Object[0]) + (time != null ? Utils.formatExecutionTime(time) + TraceBundle.message("console.trace.timeSuffix", new Object[0]) : ""), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Override
    protected void setTooltip(PresentationData presentation) {
        presentation.setTooltip(this.getSummary());
    }

    @Override
    protected void updateEventData(EventMetadataExtended eventData) {
        this.myEvent.addFiles(eventData.getFiles(), eventData.getFileIds());
        this.myEvent.setLastEntry(eventData.getLastEntry());
        this.setExecutionTime();
        this.setSummary();
        this.myParent.updateEventData(eventData);
    }

    @Override
    public boolean isAlwaysLeaf() {
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/events/EventNode", "getName"));
        }
        return string;
    }

    protected Double getExecutionTime() {
        return this.myExecutionTime;
    }

    private String getSummary() {
        return this.mySummary;
    }

    protected void reParent(EventTreeNode newParent) {
        this.myParent = newParent;
    }

    @Override
    protected void doUpdate() {
        PresentationData presentation = this.getPresentation();
        presentation.clearText();
        this.setText(presentation);
        this.setTooltip(presentation);
    }

    @Nullable
    public NodeDescriptor getParentDescriptor() {
        return this.myParent;
    }

    public long getEventId() {
        return this.myEvent.getEventId();
    }

    public EventMetadataExtended getEvent() {
        return this.myEvent;
    }
}

