/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.common.SessionRunning;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.events.EventMessageNode;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventRootNode;
import com.intellij.javascript.trace.execution.events.EventStreamInterruptedNode;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.EventTreeStructure;
import com.intellij.javascript.trace.execution.events.NodeWithRemovableChildren;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventTree
extends SimpleTree
implements Disposable,
OccurenceNavigator {
    private final EventTreeStructure myEventTreeStructure;
    private final SimpleTreeBuilder myEventTreeBuilder;
    private List<Consumer<EventStreamNode>> myTraceClosedHandlers;
    private List<Runnable> myInterruptedNodeSelectionHandlers;
    private List<Runnable> myLabelNodeSelectionHandlers;
    private List<Consumer<EventStreamCommand>> myBrowserCommandHandlers;
    private TraceProjectSettings.EventFilterState myActiveFilter;
    private boolean myIsAutoExpanding;
    private TraceSettingsManager myTraceSettingsManager;
    private SessionRunning myIsSessionRunning;
    private boolean myIsNodeJsSession;
    private TraceContext myTraceContext;

    public EventTree(@NotNull TraceContext traceContext, SessionRunning isSessionRunning, boolean isNodeJsSession) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/events/EventTree", "<init>"));
        }
        this.myTraceClosedHandlers = new ArrayList<Consumer<EventStreamNode>>();
        this.myInterruptedNodeSelectionHandlers = new ArrayList<Runnable>();
        this.myLabelNodeSelectionHandlers = new ArrayList<Runnable>();
        this.myBrowserCommandHandlers = new ArrayList<Consumer<EventStreamCommand>>();
        this.myActiveFilter = TraceProjectSettings.EventFilterState.NULL_FILTER;
        this.myTraceContext = traceContext;
        this.myTraceSettingsManager = traceContext.getTraceSettingsManager();
        this.myIsSessionRunning = isSessionRunning;
        this.myIsNodeJsSession = isNodeJsSession;
        this.myTraceSettingsManager.addSettingsConsumer((Consumer<TraceSettings>)((Consumer)settings -> {
            this.myActiveFilter = settings.getFilter();
        }));
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)actionManager.getAction("Spy-js.Event.Tree");
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (EventTree.this.myIsAutoExpanding) {
                    EventTree.this.myIsAutoExpanding = false;
                    return;
                }
                EventTree.this.setSelectionPath(event.getPath());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.myEventTreeStructure = new EventTreeStructure();
        this.myEventTreeBuilder = new SimpleTreeBuilder((JTree)((Object)this), this.getBuilderModel(), (AbstractTreeStructure)this.myEventTreeStructure, null);
        this.myEventTreeBuilder.initRootNode();
        this.myEventTreeBuilder.updateFromRoot();
        this.getRootElement().addCappedHandler((Consumer<EventTreeNode>)((Consumer)node -> {
            if (node.equals(this.getSelectedNode())) {
                this.myEventTreeBuilder.select((Object)node.getParent());
            }
        }));
    }

    public boolean isSessionRunning() {
        return this.myIsSessionRunning.isRunning();
    }

    public void eventStreamInterruptedNodeSelected() {
        for (Runnable handler : this.myInterruptedNodeSelectionHandlers) {
            handler.run();
        }
    }

    public void eventStreamLabelNodeSelected() {
        for (Runnable handler : this.myLabelNodeSelectionHandlers) {
            handler.run();
        }
    }

    public void browserCommandExecutionRequested(@NotNull EventStreamCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/javascript/trace/execution/events/EventTree", "browserCommandExecutionRequested"));
        }
        for (Consumer<EventStreamCommand> handler : this.myBrowserCommandHandlers) {
            handler.consume((Object)command);
        }
    }

    private void eventStreamCloseRequested(EventStreamNode eventStreamNodeNode) {
        for (Consumer<EventStreamNode> handler : this.myTraceClosedHandlers) {
            handler.consume((Object)eventStreamNodeNode);
        }
    }

    public void update(NodeWithRemovableChildren node) {
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdateFrom((Object)node, true, true));
    }

    public void addEventStreamInterruptedNodeSelectionHandler(Runnable interruptedNodeSelectionHandler) {
        this.myInterruptedNodeSelectionHandlers.add(interruptedNodeSelectionHandler);
    }

    public void addEventStreamLabelNodeSelectionHandler(Runnable labelNodeSelectionHandler) {
        this.myLabelNodeSelectionHandlers.add(labelNodeSelectionHandler);
    }

    public void addTraceCloseRequestedHandler(Consumer<EventStreamNode> traceClosedHandler) {
        this.myTraceClosedHandlers.add(traceClosedHandler);
    }

    public void addBrowserCommandHandler(Consumer<EventStreamCommand> handler) {
        this.myBrowserCommandHandlers.add(handler);
    }

    public void clear(boolean onlyInactive, boolean clearCache) {
        EventRootNode root = this.getRootElement();
        for (SimpleNode node : root.getChildren()) {
            EventTreeNode eventTreeNode = (EventTreeNode)node;
            if (onlyInactive && (!(eventTreeNode instanceof EventStreamNode) || !((EventStreamNode)eventTreeNode).isExpired())) continue;
            root.removeChild(eventTreeNode);
        }
        if (clearCache) {
            root.clearRemovedElementsCache();
        }
        this.myEventTreeBuilder.queueUpdate();
    }

    public void addEventStream(ContextMetadata context) {
        this.getRootElement().addEventStream(context);
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdate());
    }

    @NotNull
    public EventNode[] getAllEventNodesOrderedByOccurenceTimeDesc() {
        EventRootNode rootElement = this.getRootElement();
        EventNode[] eventNodeArray = rootElement.getAllEventNodesOrderedByOccurenceTimeDesc();
        if (eventNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/events/EventTree", "getAllEventNodesOrderedByOccurenceTimeDesc"));
        }
        return eventNodeArray;
    }

    public boolean hasDocuments() {
        SimpleNode[] children = this.getRootElement().getChildren();
        return children.length > 0 && !(children[0] instanceof EventMessageNode);
    }

    public boolean hasExpiredDocuments() {
        return ContainerUtil.find((Object[])this.getRootElement().getChildren(), node -> node instanceof EventStreamNode && ((EventStreamNode)node).isExpired()) != null;
    }

    private EventRootNode getRootElement() {
        return (EventRootNode)this.myEventTreeStructure.getRootElement();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEventTreeBuilder);
    }

    public void interruptEventStream(String streamId) {
        if (this.myActiveFilter.matchesEventName(EventStreamInterruptedNode.NODE_TEXT)) {
            return;
        }
        EventStreamNode streamNode = this.getRootElement().eventStreamInterrupted(streamId);
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdateFrom((Object)streamNode, true, true));
    }

    public void addLabel(@NotNull EventStreamNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/events/EventTree", "addLabel"));
        }
        node.labelled();
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdateFrom((Object)node, true, true));
    }

    @Nullable
    public EventStreamNode getCurrentStreamNode() {
        if (this.getRootElement().getChildren().length == 1 && this.getRootElement().getChildren()[0] instanceof EventStreamNode) {
            return (EventStreamNode)this.getRootElement().getChildren()[0];
        }
        SimpleNode contextNode = this.getCurrentContextNode();
        if (contextNode instanceof EventStreamNode) {
            return (EventStreamNode)contextNode;
        }
        return null;
    }

    public void expireEventStream(@NotNull String streamId) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/events/EventTree", "expireEventStream"));
        }
        this.getRootElement().eventStreamExpired(streamId);
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdate(false));
    }

    public void activateEventStream(@NotNull String streamId) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/events/EventTree", "activateEventStream"));
        }
        this.getRootElement().eventStreamActivated(streamId);
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdate(false));
    }

    public void eventMetadataReceived(EventMetadataExtended metadata) {
        EventRootNode root = this.getRootElement();
        if (!root.addOrUpdateEvent(metadata, this.myActiveFilter)) {
            this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(this.myEventTreeBuilder.queueUpdate(false));
            return;
        }
        EventStreamNode streamNode = root.getEventStream(metadata.getStreamId());
        if (streamNode == null) {
            return;
        }
        ActionCallback result = this.myEventTreeBuilder.queueUpdateFrom((Object)streamNode, true, true);
        this.syncViewportRelativeToSelectedNodeAfterTreeUpdate(result);
        if (streamNode.shouldBeExpanded()) {
            result.doWhenDone(() -> {
                this.myIsAutoExpanding = true;
                this.myEventTreeBuilder.expand((Object)streamNode, null);
                streamNode.expanded();
            });
        }
    }

    private void syncViewportRelativeToSelectedNodeAfterTreeUpdate(ActionCallback result) {
        TreePath originalPath = this.getSelectionPath();
        if (originalPath != null) {
            Rectangle originalSelectedBounds = this.getPathBounds(originalPath);
            Rectangle originalViewportBounds = this.getVisibleRect();
            if (originalSelectedBounds != null) {
                int originalSelectedBoundsY = this.getPathBounds((TreePath)originalPath).y;
                int originalViewportBoundsY = originalViewportBounds.y;
                result.doWhenDone(() -> {
                    TreePath newPath = this.getSelectionPath();
                    if (newPath == null || !newPath.equals(originalPath)) {
                        return;
                    }
                    Rectangle newSelectedBounds = this.getPathBounds(newPath);
                    if (newSelectedBounds == null) {
                        return;
                    }
                    int newSelectedBoundsY = newSelectedBounds.y;
                    int diff = newSelectedBoundsY - originalSelectedBoundsY;
                    Rectangle viewportBounds = this.getVisibleRect();
                    if (diff != 0 && viewportBounds.y == originalViewportBoundsY) {
                        viewportBounds.y += diff;
                        this.revalidate();
                        this.scrollRectToVisible(viewportBounds);
                    }
                });
            }
        }
    }

    public void closeTrace(EventStreamNode streamNode) {
        this.eventStreamCloseRequested(streamNode);
    }

    public boolean hasNextOccurence() {
        SimpleNode selectedNode = this.getCurrentContextNode();
        if (selectedNode == null) {
            return false;
        }
        return !EventTree.isLastContext(selectedNode);
    }

    public boolean hasPreviousOccurence() {
        SimpleNode selectedNode = this.getCurrentContextNode();
        if (selectedNode == null) {
            return false;
        }
        return !EventTree.isFirstContext(selectedNode);
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.goTo(false);
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.goTo(true);
    }

    public String getNextOccurenceActionName() {
        return TraceBundle.message("console.trace.toolbar.next", new Object[0]);
    }

    public String getPreviousOccurenceActionName() {
        return TraceBundle.message("console.trace.toolbar.prev", new Object[0]);
    }

    private OccurenceNavigator.OccurenceInfo goTo(boolean back) {
        SimpleNode selectedNode = this.getCurrentContextNode();
        if (selectedNode == null) {
            return null;
        }
        SimpleNode[] contexts = selectedNode.getParent().getChildren();
        int index = EventTree.getContextNodeIndex(selectedNode) + (back ? -1 : 1);
        return new OccurenceNavigator.OccurenceInfo((Navigatable)new MyContextNodeNavigatable(this, this.myEventTreeBuilder, contexts[index]), index + 1, contexts.length);
    }

    private static int getContextNodeIndex(@NotNull SimpleNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/events/EventTree", "getContextNodeIndex"));
        }
        SimpleNode[] contexts = node.getParent().getChildren();
        return Arrays.asList(contexts).indexOf(node);
    }

    private static boolean isLastContext(@NotNull SimpleNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/events/EventTree", "isLastContext"));
        }
        SimpleNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        SimpleNode[] contexts = parent.getChildren();
        return Arrays.asList(contexts).indexOf(node) == contexts.length - 1;
    }

    private static boolean isFirstContext(@NotNull SimpleNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/events/EventTree", "isFirstContext"));
        }
        SimpleNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        SimpleNode[] contexts = parent.getChildren();
        return Arrays.asList(contexts).indexOf(node) == 0;
    }

    private SimpleNode getCurrentContextNode() {
        SimpleNode selectedNode = this.getSelectedNode();
        if (selectedNode == null || !(selectedNode instanceof EventTreeNode)) {
            return null;
        }
        SimpleNode parent = selectedNode;
        while (!(parent instanceof EventRootNode)) {
            selectedNode = parent;
            parent = selectedNode.getParent();
        }
        return selectedNode;
    }

    public TraceSettingsManager getTraceSettingsManager() {
        return this.myTraceSettingsManager;
    }

    public boolean isNodeJsSession() {
        return this.myIsNodeJsSession;
    }

    public void setSelected(@Nullable EventNode node) {
        if (node == null) {
            return;
        }
        this.setSelectedNode((AbstractTreeBuilder)this.myEventTreeBuilder, node, true);
    }

    @Nullable
    public EventNode getSelectedEventNode() {
        SimpleNode selectedNode = this.getSelectedNode();
        return selectedNode instanceof EventNode ? (EventNode)selectedNode : null;
    }

    public TraceContext getTraceContext() {
        return this.myTraceContext;
    }

    @Nullable
    public EventNode getEventNodeByEventId(@NotNull String streamId, long eventId) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/events/EventTree", "getEventNodeByEventId"));
        }
        return this.getRootElement().getEventNodeByEventId(streamId, eventId);
    }

    private static class MyContextNodeNavigatable
    implements Navigatable {
        private SimpleTree myTree;
        private SimpleTreeBuilder myBuilder;
        private SimpleNode myNode;

        private MyContextNodeNavigatable(SimpleTree tree, SimpleTreeBuilder builder, SimpleNode node) {
            this.myTree = tree;
            this.myBuilder = builder;
            this.myNode = node;
        }

        public void navigate(boolean requestFocus) {
            this.myTree.setSelectedNode((AbstractTreeBuilder)this.myBuilder, this.myNode, true);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }
    }
}

