/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.actions.EventStreamAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public abstract class ActiveEventStreamAction
extends EventStreamAction {
    @Override
    protected final void doUpdate(@NotNull AnActionEvent e, @NotNull EventStreamNode streamNode, @NotNull EventTree context) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doUpdate"));
        }
        if (streamNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamNode", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doUpdate"));
        }
        if (streamNode.isExpired() || !context.isSessionRunning()) {
            e.getPresentation().setEnabled(false);
        } else {
            this.doUpdateActive(e, streamNode, context);
        }
    }

    protected void doUpdateActive(@NotNull AnActionEvent e, @NotNull EventStreamNode streamNode, @NotNull EventTree context) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doUpdateActive"));
        }
        if (streamNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamNode", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doUpdateActive"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doUpdateActive"));
        }
    }

    @Override
    protected void doPerform(@NotNull EventStreamNode streamNode, @NotNull EventTree context) {
        if (streamNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamNode", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ActiveEventStreamAction", "doPerform"));
        }
        context.browserCommandExecutionRequested(new EventStreamCommand(streamNode.getStreamId(), this.getCommand()));
    }

    @NotNull
    protected abstract String getCommand();
}

