/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.actions.EventGroupOrNodeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AddEventToFilterAction
extends EventGroupOrNodeAction {
    @Override
    public void doUpdate(@NotNull AnActionEvent e, @NotNull EventTreeNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddEventToFilterAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddEventToFilterAction", "doUpdate"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddEventToFilterAction", "doUpdate"));
        }
        TraceProjectSettings.EventFilterState activeFilter = tree.getTraceSettingsManager().getActiveFilter();
        if (activeFilter.matchesEventName(context.getName())) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setText(String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteEventTemplate", new Object[0]), context.getName()), false);
        }
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull EventTreeNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddEventToFilterAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddEventToFilterAction", "doPerform"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddEventToFilterAction", "doPerform"));
        }
        TraceSettingsManager traceSettingsManager = tree.getTraceSettingsManager();
        String eventName = context.getName();
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("event");
        condition.setValue(StringUtil.escapeBackSlashes((String)eventName));
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteNameSuggestionTemplate", new Object[0]), eventName));
    }

    @Override
    protected boolean isAvailableForLoadedTrace() {
        return false;
    }
}

