/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.actions.EventGroupOrNodeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AddNegatedEventToFilterAction
extends EventGroupOrNodeAction {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull EventTreeNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddNegatedEventToFilterAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddNegatedEventToFilterAction", "doUpdate"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddNegatedEventToFilterAction", "doUpdate"));
        }
        TraceProjectSettings.EventFilterState activeFilter = tree.getTraceSettingsManager().getActiveFilter();
        if (!TraceProjectSettings.EventFilterState.isAllOrNothingFilter(activeFilter)) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setText(String.format(TraceBundle.message("console.trace.toolbar.filterEvents.captureOnlyEventTemplate", new Object[0]), context.getName()), false);
        }
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull EventTreeNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddNegatedEventToFilterAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddNegatedEventToFilterAction", "doPerform"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddNegatedEventToFilterAction", "doPerform"));
        }
        TraceSettingsManager traceSettingsManager = tree.getTraceSettingsManager();
        String eventName = context.getName();
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("event");
        condition.setValue("!" + StringUtil.escapeBackSlashes((String)eventName));
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, String.format(TraceBundle.message("console.trace.toolbar.filterEvents.captureOnlyNameSuggestionTemplate", new Object[0]), eventName));
    }

    @Override
    protected boolean isAvailableForLoadedTrace() {
        return false;
    }
}

