/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyTree;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyDetailsPanel
extends JPanel {
    private final JScrollPane myPane;
    private FileDependencyTree myTree;
    private TraceContext myTraceContext;
    private JComponent myParent;
    private JPanel myDetailsToolbar;
    private JComponent myToolbar;

    public FileDependencyDetailsPanel(@NotNull TraceContext traceContext, @NotNull JComponent parent, @NotNull JPanel detailsToolbar) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "<init>"));
        }
        if (detailsToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsToolbar", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myTraceContext = traceContext;
        this.myParent = parent;
        this.myDetailsToolbar = detailsToolbar;
        this.myPane = ScrollPaneFactory.createScrollPane();
        this.add(this.myPane);
        this.createEmptyTree();
        this.updateToolbar();
    }

    private void updateToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        this.myToolbar = actionManager.createActionToolbar("unknown", FileDependencyDetailsPanel.getDetailsToolbarActionGroup(this.myTree, this.myParent), true).getComponent();
        this.myDetailsToolbar.add((Component)this.myToolbar, "Center");
    }

    private void createEmptyTree() {
        this.resetDetails();
        this.myTree = new FileDependencyTree(this.myTraceContext);
        this.myPane.setViewportView((Component)((Object)this.myTree));
        this.updateToolbar();
    }

    public void displayNodeDetails(@NotNull String streamId, @Nullable FileNode node) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "displayNodeDetails"));
        }
        if (node == null) {
            this.createEmptyTree();
            return;
        }
        this.updateTree(streamId, node, null);
    }

    public void displayEdgeDetails(@NotNull String streamId, @Nullable RuntimeDependencyEdge edge) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "displayEdgeDetails"));
        }
        if (edge == null) {
            this.createEmptyTree();
            return;
        }
        this.updateTree(streamId, edge.getSource(), edge);
    }

    private void updateTree(@NotNull String streamId, @NotNull FileNode source, @Nullable RuntimeDependencyEdge edge) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "updateTree"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "updateTree"));
        }
        this.resetDetails();
        this.myTree = new FileDependencyTree(this.myTraceContext, streamId, source, edge);
        this.myPane.setViewportView((Component)((Object)this.myTree));
        this.updateToolbar();
    }

    private void resetDetails() {
        this.myPane.setViewportView(null);
        if (this.myTree != null) {
            Disposer.dispose((Disposable)this.myTree);
        }
        if (this.myToolbar != null) {
            this.myDetailsToolbar.remove(this.myToolbar);
        }
    }

    private static ActionGroup getDetailsToolbarActionGroup(@NotNull SimpleTree tree, @NotNull JComponent parent) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "getDetailsToolbarActionGroup"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel", "getDetailsToolbarActionGroup"));
        }
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)tree);
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction action = actionsManager.createExpandAllAction((TreeExpander)treeExpander, parent);
        action.getTemplatePresentation().setDescription(TraceBundle.message("fileDependency.details.toolbar.expand", new Object[0]));
        actionGroup.add(action);
        action = actionsManager.createCollapseAllAction((TreeExpander)treeExpander, parent);
        action.getTemplatePresentation().setDescription(TraceBundle.message("fileDependency.details.toolbar.collapse", new Object[0]));
        actionGroup.add(action);
        return actionGroup;
    }
}

