/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.editor.FileDependencyGraphViewer;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2DNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyGraphPresentation
extends SelectionDependenciesPresentationModel<FileNode, RuntimeDependencyEdge> {
    private Consumer<FileNode> myOnNodeSelected;
    private Consumer<RuntimeDependencyEdge> myOnEdgeSelected;
    private RuntimeDependencyEdge mySelectedEdge;
    private FileNode mySelectedNode;

    public FileDependencyGraphPresentation(@NotNull Graph graph, @NotNull Consumer<FileNode> onNodeSelected, @NotNull Consumer<RuntimeDependencyEdge> onEdgeSelected) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "<init>"));
        }
        if (onNodeSelected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onNodeSelected", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "<init>"));
        }
        if (onEdgeSelected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onEdgeSelected", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "<init>"));
        }
        super(graph, false);
        this.myOnNodeSelected = onNodeSelected;
        this.myOnEdgeSelected = onEdgeSelected;
    }

    protected DefaultActionGroup getCommonActionGroup() {
        return super.getCommonActionGroup();
    }

    public String getNodeTooltip(@Nullable FileNode node) {
        if (node == null) {
            return null;
        }
        return StringUtil.first((String)node.getUrl(), (int)100, (boolean)true);
    }

    public String getEdgeTooltip(@Nullable RuntimeDependencyEdge edge) {
        if (edge == null) {
            return null;
        }
        return StringUtil.first((String)edge.getName(), (int)100, (boolean)true);
    }

    public EdgeLabel[] getEdgeLabels(RuntimeDependencyEdge edge, String edgeName) {
        EdgeLabel[] labels;
        for (EdgeLabel label : labels = super.getEdgeLabels((Object)edge, edgeName)) {
            label.setTextColor(edge.getSource().getFileColor());
        }
        return labels;
    }

    public DefaultActionGroup getPaperActionGroup() {
        return FileDependencyGraphViewer.getGraphToolbarActionGroup();
    }

    protected void addGraph2DSelectionListener(final GraphBuilder<FileNode, RuntimeDependencyEdge> builder) {
        super.addGraph2DSelectionListener(builder);
        builder.getGraph().addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
                List selectedNodes = GraphUtil.getSelectedNodes((GraphBuilder)builder);
                List selectedEdges = FileDependencyGraphPresentation.getSelectedEdges((GraphBuilder<FileNode, RuntimeDependencyEdge>)builder);
                if (selectedNodes.size() > 1 || selectedEdges.size() > 1 || selectedNodes.size() == 1 && selectedEdges.size() == 1 || selectedNodes.size() == 0 && selectedEdges.size() == 0) {
                    FileDependencyGraphPresentation.this.mySelectedNode = null;
                    FileDependencyGraphPresentation.this.mySelectedEdge = null;
                    FileDependencyGraphPresentation.this.myOnNodeSelected.consume(null);
                    FileDependencyGraphPresentation.this.myOnEdgeSelected.consume(null);
                    return;
                }
                if (selectedNodes.size() == 1) {
                    FileNode node = (FileNode)selectedNodes.get(0);
                    if (node != null && FileDependencyGraphPresentation.this.mySelectedNode != node) {
                        FileDependencyGraphPresentation.this.mySelectedNode = node;
                        FileDependencyGraphPresentation.this.mySelectedEdge = null;
                        FileDependencyGraphPresentation.this.myOnNodeSelected.consume((Object)node);
                    }
                } else {
                    RuntimeDependencyEdge edge = (RuntimeDependencyEdge)selectedEdges.get(0);
                    if (edge != null && FileDependencyGraphPresentation.this.mySelectedEdge != edge) {
                        FileDependencyGraphPresentation.this.mySelectedEdge = edge;
                        FileDependencyGraphPresentation.this.mySelectedNode = null;
                        FileDependencyGraphPresentation.this.myOnEdgeSelected.consume((Object)edge);
                    }
                }
            }
        });
    }

    private static List<RuntimeDependencyEdge> getSelectedEdges(GraphBuilder<FileNode, RuntimeDependencyEdge> builder) {
        ArrayList<RuntimeDependencyEdge> selectedEdges = new ArrayList<RuntimeDependencyEdge>();
        EdgeCursor cursor = builder.getGraph().selectedEdges();
        while (cursor.ok()) {
            Edge edge = cursor.edge();
            RuntimeDependencyEdge edgeObject = (RuntimeDependencyEdge)builder.getEdgeObject(edge);
            if (edgeObject != null) {
                selectedEdges.add(edgeObject);
            }
            cursor.next();
        }
        return selectedEdges;
    }

    public EdgeCreationPolicy<FileNode> getEdgeCreationPolicy() {
        return new EdgeCreationPolicy<FileNode>(){

            public boolean acceptSource(@NotNull FileNode source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation$2", "acceptSource"));
                }
                return false;
            }

            public boolean acceptTarget(@NotNull FileNode target) {
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation$2", "acceptTarget"));
                }
                return false;
            }
        };
    }

    public DeleteProvider getDeleteProvider() {
        return null;
    }

    @NotNull
    public GraphBuilder<FileNode, RuntimeDependencyEdge> getGraphBuilder() {
        GraphBuilder graphBuilder = super.getGraphBuilder();
        if (graphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "getGraphBuilder"));
        }
        return graphBuilder;
    }

    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable FileNode node) {
        Graph2DNodeRealizer realizer = GraphManager.getGraphManager().createGraph2DNodeRealizer();
        if (node == null) {
            Graph2DNodeRealizer graph2DNodeRealizer = realizer;
            if (graph2DNodeRealizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "getNodeRealizer"));
            }
            return graph2DNodeRealizer;
        }
        String module = node.getNodeModule();
        if (!StringUtil.isEmpty((String)module)) {
            realizer = GraphManager.getGraphManager().createShapeNodeRealizer((byte)5);
        }
        Color color = node.getFileColor();
        realizer.setFillColor(color);
        realizer.setLineColor(color);
        NodeLabel label = realizer.createNodeLabel();
        label.setTextColor(color);
        label.setPosition(NodeLabel.BOTTOM);
        label.setDistance(-20.0);
        label.setText((!StringUtil.isEmpty((String)module) ? module + ": " : "") + node.getShortFileName());
        realizer.setLabel(label);
        Graph2DNodeRealizer graph2DNodeRealizer = realizer;
        if (graph2DNodeRealizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "getNodeRealizer"));
        }
        return graph2DNodeRealizer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable RuntimeDependencyEdge edge) {
        EdgeRealizer realizer = super.getEdgeRealizer((Object)edge);
        if (edge == null) {
            EdgeRealizer edgeRealizer = realizer;
            if (edgeRealizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "getEdgeRealizer"));
            }
            return edgeRealizer;
        }
        realizer.setLineColor(edge.getSource().getFileColor());
        EdgeRealizer edgeRealizer = realizer;
        if (edgeRealizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraphPresentation", "getEdgeRealizer"));
        }
        return edgeRealizer;
    }
}

