/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.actions.StackTreeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AddNegatedFileToFilterAction
extends StackTreeAction {
    @Override
    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/AddNegatedFileToFilterAction", "doUpdate"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/AddNegatedFileToFilterAction", "doUpdate"));
        }
        if (!TraceProjectSettings.EventFilterState.isAllOrNothingFilter(tree.getTraceSettingsManager().getActiveFilter())) {
            e.getPresentation().setVisible(false);
        }
    }

    @Override
    protected void doPerform(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/AddNegatedFileToFilterAction", "doPerform"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/AddNegatedFileToFilterAction", "doPerform"));
        }
        TraceSettingsManager traceSettingsManager = tree.getTraceSettingsManager();
        TraceProjectSettings.EventFilterState activeFilter = traceSettingsManager.getActiveFilter();
        if (!TraceProjectSettings.EventFilterState.isAllOrNothingFilter(activeFilter)) {
            return;
        }
        String file = selectedNode.getFile();
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("file");
        condition.setValue("!" + StringUtil.escapeBackSlashes((String)file));
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, String.format(TraceBundle.message("console.trace.toolbar.filterEvents.captureOnlyNameSuggestionTemplate", new Object[0]), Utils.getShortFileName(file)));
    }
}

