/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventFilterConditionDialog
extends DialogWrapper {
    private JPanel myPanel;

    protected EventFilterConditionDialog(@NotNull Component parent, final @NotNull TraceProjectSettings.EventFilterConditionState condition) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/settings/EventFilterConditionDialog", "<init>"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/javascript/trace/settings/EventFilterConditionDialog", "<init>"));
        }
        super(parent, false);
        this.myPanel = new JPanel(new BorderLayout());
        final ComboBox typeCombo = new ComboBox((Object[])TraceProjectSettings.EventFilterConditionState.getTypes(), 180);
        typeCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/trace/settings/EventFilterConditionDialog$1", "customizeCellRenderer"));
                }
                this.append(TraceProjectSettings.EventFilterConditionState.getTypeDisplayName(value.toString()));
            }
        });
        typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                condition.setType(typeCombo.getSelectedItem().toString());
            }
        });
        final JBTextField text = new JBTextField();
        text.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                condition.setValue(text.getText());
            }
        });
        typeCombo.setSelectedItem((Object)condition.getType());
        text.setText(condition.getValue());
        this.myPanel.add((Component)FormBuilder.createFormBuilder().addLabeledComponent(TraceBundle.message("settings.eventFilters.conditionType", new Object[0]), (JComponent)typeCombo).addLabeledComponent(TraceBundle.message("settings.eventFilters.conditionText", new Object[0]), (JComponent)text).getPanel(), "North");
        this.myPanel.setPreferredSize(new Dimension(350, 60));
        this.setTitle(TraceBundle.message("settings.eventFilters.condition.dialogTitle", new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }
}

