/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.cli;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u001c\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0003R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/compose/cli/DockerComposeCli;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "versionCommand", "", "extractDockerComposeVersion", "stdout", "getVersion", "dockerComposeExePath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runCommand", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Docker-remote-run"})
public final class DockerComposeCli {
    private static final Logger log;
    private static final String versionCommand = "--version";
    private static final Pattern pattern;
    public static final DockerComposeCli INSTANCE;

    @NotNull
    public final String getVersion(@NotNull String dockerComposeExePath, @Nullable ProgressIndicator indicator) throws IOException {
        GeneralCommandLine cmd;
        Intrinsics.checkParameterIsNotNull((Object)dockerComposeExePath, (String)"dockerComposeExePath");
        GeneralCommandLine generalCommandLine = cmd = new GeneralCommandLine().withExePath(dockerComposeExePath).withParameters(new String[]{versionCommand});
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"cmd");
        ProcessOutput processOutput = this.runCommand(indicator, generalCommandLine);
        if (processOutput.checkSuccess(log)) {
            String string = processOutput.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processOutput.stdout");
            return this.extractDockerComposeVersion(string);
        }
        throw (Throwable)new IOException("Running docker-compose version command failed");
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getVersion$default(DockerComposeCli dockerComposeCli, String string, ProgressIndicator progressIndicator, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return dockerComposeCli.getVersion(string, progressIndicator);
    }

    @NotNull
    public final String extractDockerComposeVersion(@NotNull String stdout) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
        Matcher matcher = pattern.matcher(stdout);
        if (matcher.find()) {
            String string = matcher.group("version");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(\"version\")");
            return string;
        }
        throw (Throwable)new IOException("Could not find version in docker-compose output");
    }

    private final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws IOException {
        CapturingProcessHandler processHandler;
        try {
            processHandler = new CapturingProcessHandler(cmd);
        }
        catch (ExecutionException e) {
            throw (Throwable)new IOException(e);
        }
        if (indicator != null) {
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator);
            Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProces\u2026gressIndicator(indicator)");
            return processOutput;
        }
        ProcessOutput processOutput = processHandler.runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProcess()");
        return processOutput;
    }

    private DockerComposeCli() {
        INSTANCE = this;
        log = Logger.getInstance(DockerComposeCli.class);
        versionCommand = versionCommand;
        pattern = Pattern.compile("docker-compose version (?<version>.+), build (?<build>.+)");
    }

    static {
        new DockerComposeCli();
    }
}

