/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import com.google.common.collect.ImmutableMap;
import com.intellij.docker.compose.commands.CreateContainerRunCmdExec;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateContainerRunCmd {
    @NotNull
    private final CreateContainerRunCmdExec myCmdExecutor;
    private List<String> myConfigurationFiles;
    private String myServiceName;
    private List<String> myServiceCmd;
    @Nullable
    private ImmutableMap<String, String> myEnvs;

    public CreateContainerRunCmd(@NotNull CreateContainerRunCmdExec cmdExecutor) {
        if (cmdExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdExecutor", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "<init>"));
        }
        this.myConfigurationFiles = ContainerUtil.emptyList();
        this.myServiceCmd = null;
        this.myCmdExecutor = cmdExecutor;
    }

    @NotNull
    public List<String> getConfigurationFiles() {
        List<String> list = Collections.unmodifiableList(this.myConfigurationFiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "getConfigurationFiles"));
        }
        return list;
    }

    @NotNull
    public CreateContainerRunCmd withConfigurationFiles(String ... dockerComposeFiles) {
        if (dockerComposeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeFiles", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withConfigurationFiles"));
        }
        this.myConfigurationFiles = ContainerUtil.newArrayList((Object[])dockerComposeFiles);
        CreateContainerRunCmd createContainerRunCmd = this;
        if (createContainerRunCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withConfigurationFiles"));
        }
        return createContainerRunCmd;
    }

    @NotNull
    public CreateContainerRunCmd withConfigurationFiles(@NotNull List<Path> dockerComposeFiles) {
        if (dockerComposeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeFiles", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withConfigurationFiles"));
        }
        CreateContainerRunCmd createContainerRunCmd = this.withConfigurationFiles((String[])dockerComposeFiles.stream().map(Path::toString).toArray(String[]::new));
        if (createContainerRunCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withConfigurationFiles"));
        }
        return createContainerRunCmd;
    }

    @Nullable
    public String getServiceName() {
        return this.myServiceName;
    }

    @NotNull
    public CreateContainerRunCmd withServiceName(String serviceName) {
        this.myServiceName = serviceName;
        CreateContainerRunCmd createContainerRunCmd = this;
        if (createContainerRunCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withServiceName"));
        }
        return createContainerRunCmd;
    }

    @Nullable
    public List<String> getServiceCmd() {
        return this.myServiceCmd != null ? Collections.unmodifiableList(this.myServiceCmd) : null;
    }

    @NotNull
    public CreateContainerRunCmd withServiceCmd(String ... serviceCmd) {
        this.myServiceCmd = serviceCmd != null ? ContainerUtil.newArrayList((Object[])serviceCmd) : null;
        CreateContainerRunCmd createContainerRunCmd = this;
        if (createContainerRunCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withServiceCmd"));
        }
        return createContainerRunCmd;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvs() {
        return this.myEnvs;
    }

    @NotNull
    public CreateContainerRunCmd withEnvs(@Nullable ImmutableMap<String, String> envs) {
        this.myEnvs = envs;
        CreateContainerRunCmd createContainerRunCmd = this;
        if (createContainerRunCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "withEnvs"));
        }
        return createContainerRunCmd;
    }

    @NotNull
    public RemoteDockerApplicationRuntime exec() throws IOException, ServerRuntimeException {
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = this.myCmdExecutor.exec(this);
        if (remoteDockerApplicationRuntime == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerRunCmd", "exec"));
        }
        return remoteDockerApplicationRuntime;
    }
}

