/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import com.google.common.collect.ImmutableMap;
import com.intellij.docker.compose.commands.CreateContainerUpCmdExec;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateContainerUpCmd {
    @NotNull
    private final CreateContainerUpCmdExec myCmdExecutor;
    private List<String> myConfigurationFiles;
    @Nullable
    private ImmutableMap<String, String> myEnvs;

    public CreateContainerUpCmd(@NotNull CreateContainerUpCmdExec cmdExecutor) {
        if (cmdExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdExecutor", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "<init>"));
        }
        this.myConfigurationFiles = ContainerUtil.emptyList();
        this.myCmdExecutor = cmdExecutor;
    }

    @NotNull
    public List<String> getConfigurationFiles() {
        List<String> list = Collections.unmodifiableList(this.myConfigurationFiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "getConfigurationFiles"));
        }
        return list;
    }

    @NotNull
    public CreateContainerUpCmd withConfigurationFiles(String ... dockerComposeFiles) {
        if (dockerComposeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeFiles", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "withConfigurationFiles"));
        }
        this.myConfigurationFiles = ContainerUtil.newArrayList((Object[])dockerComposeFiles);
        CreateContainerUpCmd createContainerUpCmd = this;
        if (createContainerUpCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "withConfigurationFiles"));
        }
        return createContainerUpCmd;
    }

    @NotNull
    public CreateContainerUpCmd withConfigurationFiles(@NotNull List<Path> dockerComposeFiles) {
        if (dockerComposeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeFiles", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "withConfigurationFiles"));
        }
        CreateContainerUpCmd createContainerUpCmd = this.withConfigurationFiles((String[])dockerComposeFiles.stream().map(Path::toString).toArray(String[]::new));
        if (createContainerUpCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "withConfigurationFiles"));
        }
        return createContainerUpCmd;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvs() {
        return this.myEnvs;
    }

    @NotNull
    public CreateContainerUpCmd withEnvs(@Nullable ImmutableMap<String, String> envs) {
        this.myEnvs = envs;
        CreateContainerUpCmd createContainerUpCmd = this;
        if (createContainerUpCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "withEnvs"));
        }
        return createContainerUpCmd;
    }

    @NotNull
    public RemoteDockerApplicationRuntime exec() throws IOException, ServerRuntimeException {
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = this.myCmdExecutor.exec(this);
        if (remoteDockerApplicationRuntime == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerUpCmd", "exec"));
        }
        return remoteDockerApplicationRuntime;
    }
}

