/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import com.google.common.base.Charsets;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.compose.DockerComposeProjectService;
import com.intellij.docker.compose.commands.DockerComposeVersion;
import com.intellij.docker.compose.commands.IntellijLogChute;
import com.intellij.docker.compose.commands.ResourceUtil;
import com.intellij.docker.remote.run.runtime.DockerAgentBuildImageConfig;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class DockerComposeImageManager {
    private static final String DOCKER_COMPOSE_IMAGE_NAME = "docker/compose";
    private static final String DOCKER_COMPOSE_CUSTOM_BUILD = "2";
    private static final String LEGACY_CUSTOM_DOCKER_COMPOSE_IMAGE_NAME = "pycharm/docker/compose";
    private static final String CUSTOM_DOCKER_COMPOSE_IMAGE_NAME = "intellij/docker/compose";
    private static final String TEMPLATE_VAR_TAG = "tag";
    private static final String TEMPLATE_VAR_VERSION = "version";
    private static final String TEMPLATE_VAR_CUSTOM_BUILD = "customBuild";
    private static final String TEMPLATE_FILENAME_EXTENSION = ".template";
    private static final String LATEST_SUPPORTED_DOCKER_COMPOSE_VERSION = "1.11.2";
    @NotNull
    private final RemoteDockerRuntime myDockerRuntime;
    private static final Lock ourLock = new ReentrantLock();
    private static final Logger LOG = Logger.getInstance(DockerComposeImageManager.class);

    public DockerComposeImageManager(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerRuntime", "com/intellij/docker/compose/commands/DockerComposeImageManager", "<init>"));
        }
        this.myDockerRuntime = dockerRuntime;
    }

    @NotNull
    public String getImageName() {
        String string = DockerComposeImageManager.getImageName(this.getDockerComposeVersion(false));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/DockerComposeImageManager", "getImageName"));
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    private static String getImageName(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TEMPLATE_VAR_VERSION, "com/intellij/docker/compose/commands/DockerComposeImageManager", "getImageName"));
        }
        String string = "intellij/docker/compose:" + version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/DockerComposeImageManager", "getImageName"));
        }
        return string;
    }

    @NotNull
    private String getDockerComposeVersion(boolean onBuildingImage) {
        String localVersion = DockerComposeProjectService.getInstance().getDockerComposeVersion(this.myDockerRuntime.getAccount());
        DockerComposeVersion version = DockerComposeVersion.Companion.parse(localVersion);
        if (version != null && version.getMajor() >= 1 && version.getMinor() >= 12) {
            if (onBuildingImage) {
                LOG.info("Locally installed docker-compose version " + localVersion + " is not supported. Using latest supported docker-compose version " + LATEST_SUPPORTED_DOCKER_COMPOSE_VERSION);
            }
            localVersion = LATEST_SUPPORTED_DOCKER_COMPOSE_VERSION;
        }
        String string = localVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/DockerComposeImageManager", "getDockerComposeVersion"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildImage() throws IOException, ServerRuntimeException {
        ourLock.lock();
        try {
            File folder;
            String dockerComposeVersion = this.getDockerComposeVersion(true);
            String imageName = CUSTOM_DOCKER_COMPOSE_IMAGE_NAME + dockerComposeVersion;
            DockerAgentApplication image = this.myDockerRuntime.findImageByName(DockerComposeImageManager.getImageName(dockerComposeVersion));
            if (image != null) {
                return;
            }
            DockerComposeImageManager.removeIrrelevantComposeImages(this.myDockerRuntime);
            try {
                folder = DockerComposeImageManager.prepareDockerComposeImageSources(dockerComposeVersion);
            }
            catch (IOException e) {
                LOG.error("Failed to build custom docker-compose Docker image " + imageName, (Throwable)e);
                throw e;
            }
            DockerAgentBuildImageConfig config = new DockerAgentBuildImageConfig(DockerComposeImageManager.getImageName(dockerComposeVersion), folder, false);
            RemoteDockerApplicationRuntime.create(this.myDockerRuntime, config);
        }
        finally {
            ourLock.unlock();
        }
    }

    private static void removeIrrelevantComposeImages(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerRuntime", "com/intellij/docker/compose/commands/DockerComposeImageManager", "removeIrrelevantComposeImages"));
        }
        try {
            Arrays.stream(dockerRuntime.getImages()).filter(image -> Arrays.stream(image.getImageRepoTags()).anyMatch(DockerComposeImageManager::isCustomDockerComposeImageName)).forEach(image -> {
                if (dockerRuntime == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerRuntime", "com/intellij/docker/compose/commands/DockerComposeImageManager", "lambda$removeIrrelevantComposeImages$1"));
                }
                RemoteDockerApplicationRuntime.create(dockerRuntime, image).removeImage();
            });
        }
        catch (ServerRuntimeException serverRuntimeException) {
            // empty catch block
        }
    }

    private static boolean isCustomDockerComposeImageName(@NotNull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TEMPLATE_VAR_TAG, "com/intellij/docker/compose/commands/DockerComposeImageManager", "isCustomDockerComposeImageName"));
        }
        return tag.startsWith("intellij/docker/compose:") || tag.startsWith("pycharm/docker/compose:");
    }

    @NotNull
    static File prepareDockerComposeImageSources(@NotNull String dockerComposeVersion) throws IOException {
        if (dockerComposeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeVersion", "com/intellij/docker/compose/commands/DockerComposeImageManager", "prepareDockerComposeImageSources"));
        }
        final File tempDirectory = FileUtil.createTempDirectory((String)"intellij-docker-compose-image", null);
        final VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem", (Object)new IntellijLogChute(LOG));
        engine.init();
        final VelocityContext context = new VelocityContext();
        context.put(TEMPLATE_VAR_TAG, (Object)dockerComposeVersion);
        context.put(TEMPLATE_VAR_VERSION, (Object)dockerComposeVersion);
        context.put(TEMPLATE_VAR_CUSTOM_BUILD, (Object)DOCKER_COMPOSE_CUSTOM_BUILD);
        ResourceUtil.traverseResources(DockerComposeImageManager.class, "docker-compose", new ResourceUtil.Callback(){

            @Override
            public void handleDirectory(@NotNull String resourcePathname) throws IOException {
                if (resourcePathname == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcePathname", "com/intellij/docker/compose/commands/DockerComposeImageManager$1", "handleDirectory"));
                }
                File directory = new File(tempDirectory, resourcePathname);
                if (!FileUtil.createDirectory((File)directory)) {
                    LOG.debug("Unable to create directory: " + directory);
                }
            }

            @Override
            public void handleFile(@NotNull String resourcePathname, @NotNull InputStream inputStream, long size) throws IOException {
                if (resourcePathname == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcePathname", "com/intellij/docker/compose/commands/DockerComposeImageManager$1", "handleFile"));
                }
                if (inputStream == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/docker/compose/commands/DockerComposeImageManager$1", "handleFile"));
                }
                if (resourcePathname.endsWith(DockerComposeImageManager.TEMPLATE_FILENAME_EXTENSION)) {
                    String filename = DockerComposeImageManager.removeSuffix(resourcePathname, DockerComposeImageManager.TEMPLATE_FILENAME_EXTENSION.length());
                    try (Writer fileWriter = DockerComposeImageManager.newFileWriter(filename, tempDirectory);){
                        engine.evaluate((Context)context, fileWriter, resourcePathname, (Reader)new InputStreamReader(inputStream, Charsets.UTF_8));
                    }
                }
                try (Writer fileWriter = DockerComposeImageManager.newFileWriter(resourcePathname, tempDirectory);){
                    IOUtils.copy((InputStream)inputStream, (Writer)fileWriter);
                }
            }
        });
        File file = tempDirectory;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/DockerComposeImageManager", "prepareDockerComposeImageSources"));
        }
        return file;
    }

    @NotNull
    private static String removeSuffix(@NotNull String resourcePathname, int suffixLength) {
        if (resourcePathname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcePathname", "com/intellij/docker/compose/commands/DockerComposeImageManager", "removeSuffix"));
        }
        String string = resourcePathname.substring(0, resourcePathname.length() - suffixLength);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/DockerComposeImageManager", "removeSuffix"));
        }
        return string;
    }

    @NotNull
    private static Writer newFileWriter(@NotNull String filename, @NotNull File tempDirectory) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/docker/compose/commands/DockerComposeImageManager", "newFileWriter"));
        }
        if (tempDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirectory", "com/intellij/docker/compose/commands/DockerComposeImageManager", "newFileWriter"));
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(tempDirectory, filename)), Charsets.UTF_8);
        if (outputStreamWriter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/DockerComposeImageManager", "newFileWriter"));
        }
        return outputStreamWriter;
    }
}

