/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\b\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000f\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/compose/commands/DockerComposeVersion;", "", "major", "", "minor", "fix", "qualifier", "", "(IIILjava/lang/String;)V", "getFix", "()I", "getMajor", "getMinor", "getQualifier", "()Ljava/lang/String;", "compareQualifiers", "otherQualifier", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "Companion", "Docker-remote-run"})
public final class DockerComposeVersion
implements Comparable<DockerComposeVersion> {
    private final int major;
    private final int minor;
    private final int fix;
    @Nullable
    private final String qualifier;
    private static final Pattern VERSION_PATTERN;
    public static final Companion Companion;

    @Override
    public int compareTo(@NotNull DockerComposeVersion other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.fix != other.fix) {
            return this.fix - other.fix;
        }
        return this.compareQualifiers(this.qualifier, other.qualifier);
    }

    private final int compareQualifiers(String qualifier, String otherQualifier) {
        if (qualifier == null) {
            if (otherQualifier == null) {
                return 0;
            }
            return 1;
        }
        if (otherQualifier == null) {
            return -1;
        }
        return qualifier.compareTo(otherQualifier);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getFix() {
        return this.fix;
    }

    @Nullable
    public final String getQualifier() {
        return this.qualifier;
    }

    public DockerComposeVersion(int major, int minor, int fix, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.fix = fix;
        this.qualifier = qualifier;
    }

    public /* synthetic */ DockerComposeVersion(int n, int n2, int n3, String string, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            string = null;
        }
        this(n, n2, n3, string);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<fix>\\d+)(?<qualifier>[^\\d].*)?");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(?<majo\u2026(?<qualifier>[^\\\\d].*)?\")");
        VERSION_PATTERN = pattern;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.fix;
    }

    @Nullable
    public final String component4() {
        return this.qualifier;
    }

    @NotNull
    public final DockerComposeVersion copy(int major, int minor, int fix, @Nullable String qualifier) {
        return new DockerComposeVersion(major, minor, fix, qualifier);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DockerComposeVersion copy$default(DockerComposeVersion dockerComposeVersion, int n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = dockerComposeVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = dockerComposeVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = dockerComposeVersion.fix;
        }
        if ((n4 & 8) != 0) {
            string = dockerComposeVersion.qualifier;
        }
        return dockerComposeVersion.copy(n, n2, n3, string);
    }

    public String toString() {
        return "DockerComposeVersion(major=" + this.major + ", minor=" + this.minor + ", fix=" + this.fix + ", qualifier=" + this.qualifier + ")";
    }

    public int hashCode() {
        String string = this.qualifier;
        return ((this.major * 31 + this.minor) * 31 + this.fix) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DockerComposeVersion)) break block3;
                DockerComposeVersion dockerComposeVersion = (DockerComposeVersion)object;
                if (!(this.major == dockerComposeVersion.major) || !(this.minor == dockerComposeVersion.minor) || !(this.fix == dockerComposeVersion.fix) || !Intrinsics.areEqual((Object)this.qualifier, (Object)dockerComposeVersion.qualifier)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/compose/commands/DockerComposeVersion$Companion;", "", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "getVERSION_PATTERN", "()Ljava/util/regex/Pattern;", "parse", "Lcom/intellij/docker/compose/commands/DockerComposeVersion;", "s", "", "Docker-remote-run"})
    public static final class Companion {
        private final Pattern getVERSION_PATTERN() {
            return VERSION_PATTERN;
        }

        @Nullable
        public final DockerComposeVersion parse(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            Matcher matcher = this.getVERSION_PATTERN().matcher(s);
            if (matcher.matches()) {
                DockerComposeVersion dockerComposeVersion;
                String string = matcher.group("major");
                DockerComposeVersion dockerComposeVersion2 = dockerComposeVersion;
                DockerComposeVersion dockerComposeVersion3 = dockerComposeVersion;
                int n = Integer.parseInt(string);
                string = matcher.group("minor");
                int n2 = Integer.parseInt(string);
                string = matcher.group("fix");
                int n3 = Integer.parseInt(string);
                dockerComposeVersion2(n, n2, n3, matcher.group("qualifier"));
                return dockerComposeVersion3;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

