/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeEnvironment;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeConfigurationParser {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(\\.\\d+)?");
    @NotNull
    private final ObjectMapper myMapper;

    public DockerComposeConfigurationParser() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        SimpleModule module = new SimpleModule();
        module.addDeserializer(DockerComposeConfiguration.class, (JsonDeserializer)new DockerComposeConfigurationDeserializer());
        module.addDeserializer(DockerComposeEnvironment.class, (JsonDeserializer)new DockerComposeEnvironmentDeserializer());
        mapper.registerModule((Module)module);
        this.myMapper = mapper;
    }

    @NotNull
    DockerComposeConfiguration parseBean(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser", "parseBean"));
        }
        DockerComposeConfiguration dockerComposeConfiguration = (DockerComposeConfiguration)this.myMapper.readValue(reader, DockerComposeConfiguration.class);
        if (dockerComposeConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser", "parseBean"));
        }
        return dockerComposeConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull String dockerComposeFilePath) throws IOException {
        if (dockerComposeFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeFilePath", "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser", "parseBean"));
        }
        FileReader reader = new FileReader(dockerComposeFilePath);
        DockerComposeConfiguration dockerComposeConfiguration = this.parseBean(reader);
        DockerComposeConfiguration dockerComposeConfiguration2 = dockerComposeConfiguration;
        if (dockerComposeConfiguration2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser", "parseBean"));
        }
        return dockerComposeConfiguration2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static DockerComposeConfigurationParser newInstance() {
        DockerComposeConfigurationParser dockerComposeConfigurationParser = new DockerComposeConfigurationParser();
        if (dockerComposeConfigurationParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser", "newInstance"));
        }
        return dockerComposeConfigurationParser;
    }

    @Nullable
    private static String getMajorVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser", "getMajorVersion"));
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        return matcher.matches() ? matcher.group("major") : null;
    }

    private class DockerComposeEnvironmentDeserializer
    extends JsonDeserializer<DockerComposeEnvironment> {
        private DockerComposeEnvironmentDeserializer() {
        }

        public DockerComposeEnvironment deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            TreeNode node = jp.readValueAsTree();
            if (node.isArray()) {
                List list = (List)DockerComposeConfigurationParser.this.myMapper.convertValue((Object)node, (JavaType)context.getTypeFactory().constructCollectionType(List.class, String.class));
                return DockerComposeEnvironment.fromList(list);
            }
            if (node.isObject()) {
                Map map = (Map)DockerComposeConfigurationParser.this.myMapper.convertValue((Object)node, (JavaType)context.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
                return DockerComposeEnvironment.fromMap(map);
            }
            throw context.mappingException("Environment is expected to be either dictionary or list");
        }
    }

    private class DockerComposeConfigurationDeserializer
    extends JsonDeserializer<DockerComposeConfiguration> {
        private DockerComposeConfigurationDeserializer() {
        }

        public DockerComposeConfiguration deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            JsonNode versionField = node.get("version");
            if (versionField != null && versionField.isTextual()) {
                String version = versionField.textValue();
                String majorVersion = DockerComposeConfigurationParser.getMajorVersion(version);
                if ("2".equals(majorVersion)) {
                    return (DockerComposeConfiguration)DockerComposeConfigurationParser.this.myMapper.treeToValue((TreeNode)node, DockerComposeConfigurationV2.class);
                }
                throw context.mappingException("Unsupported docker compose configuration version: %s", new Object[]{version});
            }
            return (DockerComposeConfiguration)DockerComposeConfigurationParser.this.myMapper.treeToValue((TreeNode)node, DockerComposeConfigurationV1.class);
        }
    }
}

