/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.common;

import com.google.common.collect.Lists;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeCommand;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeEnvFile;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBase;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilder;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerComposeServiceBuilderBase<T extends DockerComposeServiceBuilderBase, R extends DockerComposeServiceBase>
implements DockerComposeServiceBuilder<T, R> {
    private String myImage;
    private List<String> myLinks;
    private List<String> myDependsOn;
    private String myWorkingDir;
    private DockerComposeCommand myEntrypoint;
    private DockerComposeCommand myCommand;
    private Map<String, String> myEnvironment;
    private String myNetwork;
    private DockerComposeEnvFile myEnvFile;
    private String myUser;
    private RestartPolicy myRestartPolicy;
    private Boolean myStdinOpen;
    private List<String> myPorts;

    @NotNull
    public T withImage(@NotNull String val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withImage"));
        }
        this.myImage = val;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withImage"));
        }
        return t;
    }

    @NotNull
    public T withLinks(@NotNull List<String> val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withLinks"));
        }
        this.myLinks = val;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withLinks"));
        }
        return t;
    }

    @NotNull
    public T withDependsOn(@NotNull List<String> val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withDependsOn"));
        }
        this.myDependsOn = val;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withDependsOn"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withWorkingDir"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withEntrypoint(String ... command) {
        this.myEntrypoint = command != null ? new DockerComposeCommand(Arrays.asList(command)) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withEntrypoint"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withEntrypointLine(@Nullable String command) {
        this.myEntrypoint = command != null ? new DockerComposeCommand(command) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withEntrypointLine"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withCommand(String ... command) {
        this.myCommand = command != null ? new DockerComposeCommand(Arrays.asList(command)) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withCommand"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withCommandLine(@Nullable String command) {
        this.myCommand = command != null ? new DockerComposeCommand(command) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withCommandLine"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withEnvironment"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withUser(@Nullable String user) {
        this.myUser = user;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withUser"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withRestartPolicy(@Nullable RestartPolicy restartPolicy) {
        this.myRestartPolicy = restartPolicy;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withRestartPolicy"));
        }
        return t;
    }

    @NotNull
    public T withNetwork(@Nullable String network) {
        this.myNetwork = network;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withNetwork"));
        }
        return t;
    }

    @NotNull
    public T withEnvFiles(String ... envFiles) {
        this.myEnvFile = envFiles != null ? new DockerComposeEnvFile(Arrays.asList(envFiles)) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withEnvFiles"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withStdinOpen(@Nullable Boolean stdinOpen) {
        this.myStdinOpen = stdinOpen;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withStdinOpen"));
        }
        return t;
    }

    @Override
    @NotNull
    public T withPorts(@Nullable List<DockerComposePort> ports) {
        this.myPorts = ports != null ? ContainerUtil.map(ports, DockerComposePort::getStringValue) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withPorts"));
        }
        return t;
    }

    @NotNull
    public T withPorts(String ... ports) {
        this.myPorts = ports != null ? Lists.newArrayList((Object[])ports) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "withPorts"));
        }
        return t;
    }

    @Override
    @NotNull
    public final R build() {
        R serviceBean = this.createServiceBean();
        ((DockerComposeServiceBase)serviceBean).setImage(this.myImage);
        ((DockerComposeServiceBase)serviceBean).setLinks(this.myLinks);
        ((DockerComposeServiceBase)serviceBean).setDependsOn(this.myDependsOn);
        ((DockerComposeServiceBase)serviceBean).setWorkingDir(this.myWorkingDir);
        ((DockerComposeServiceBase)serviceBean).setEntrypoint(this.myEntrypoint);
        ((DockerComposeServiceBase)serviceBean).setCommand(this.myCommand);
        ((DockerComposeServiceBase)serviceBean).setEnvironment(this.myEnvironment);
        ((DockerComposeServiceBase)serviceBean).setNetworkMode(this.myNetwork);
        ((DockerComposeServiceBase)serviceBean).setEnvFile(this.myEnvFile);
        ((DockerComposeServiceBase)serviceBean).setUser(this.myUser);
        ((DockerComposeServiceBase)serviceBean).setRestart(this.myRestartPolicy != null ? this.myRestartPolicy.toString() : null);
        ((DockerComposeServiceBase)serviceBean).setStdinOpen(this.myStdinOpen);
        ((DockerComposeServiceBase)serviceBean).setPorts(this.myPorts);
        R r = this.tuneServiceBean(serviceBean);
        if (r == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase", "build"));
        }
        return r;
    }

    @NotNull
    protected abstract R createServiceBean();

    @NotNull
    protected abstract R tuneServiceBean(@NotNull R var1);

    @NotNull
    protected abstract T getThis();
}

