/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v1;

import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1Builder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerComposeConfigurationV1Builder
implements DockerComposeConfigurationBuilder<DockerComposeConfigurationV1, DockerComposeServiceV1, DockerComposeServiceV1Builder> {
    private final Map<String, DockerComposeServiceV1Builder> myServices = new LinkedHashMap<String, DockerComposeServiceV1Builder>();

    @Override
    @NotNull
    public DockerComposeServiceV1Builder addService(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeConfigurationV1Builder", "addService"));
        }
        DockerComposeServiceV1Builder builder = new DockerComposeServiceV1Builder();
        this.myServices.put(name, builder);
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = builder;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeConfigurationV1Builder", "addService"));
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    public DockerComposeConfigurationV1 build() {
        LinkedHashMap<String, DockerComposeServiceV1> services = new LinkedHashMap<String, DockerComposeServiceV1>();
        for (Map.Entry<String, DockerComposeServiceV1Builder> entry : this.myServices.entrySet()) {
            services.put(entry.getKey(), (DockerComposeServiceV1)entry.getValue().build());
        }
        DockerComposeConfigurationV1 dockerComposeConfigurationV1 = new DockerComposeConfigurationV1(services);
        if (dockerComposeConfigurationV1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeConfigurationV1Builder", "build"));
        }
        return dockerComposeConfigurationV1;
    }
}

