/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v1;

import com.google.common.collect.Lists;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.configuration.beans.common.AccessMode;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilderBase;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeVolumesFromV1;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeServiceV1Builder
extends DockerComposeServiceBuilderBase<DockerComposeServiceV1Builder, DockerComposeServiceV1> {
    private String myBuild;
    private List<String> myVolumes;
    private List<DockerComposeVolumesFromV1> myVolumesFrom;

    @NotNull
    public DockerComposeServiceV1Builder withBuild(@NotNull String val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "withBuild"));
        }
        this.myBuild = val;
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "withBuild"));
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV1Builder withBindVolumes(@Nullable DockerVolumeBinding[] volumeBindings) {
        if (volumeBindings == null) {
            DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
            if (dockerComposeServiceV1Builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "withBindVolumes"));
            }
            return dockerComposeServiceV1Builder;
        }
        this.myVolumes = Lists.transform(Arrays.asList(volumeBindings), volume -> {
            StringBuilder stringBuilder = new StringBuilder();
            if (!StringUtil.isEmpty((String)volume.getHostPath())) {
                stringBuilder.append(volume.getHostPath()).append(":");
            }
            stringBuilder.append(volume.getContainerPath());
            if (!StringUtil.isEmpty((String)volume.getHostPath()) && !volume.isReadOnly()) {
                stringBuilder.append(":").append(AccessMode.RW.getCode());
            }
            return stringBuilder.toString();
        });
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "withBindVolumes"));
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public DockerComposeServiceV1Builder addVolume(@NotNull String containerPath) {
        if (containerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerPath", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(containerPath);
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public DockerComposeServiceV1Builder addVolume(@NotNull String hostPath, @NotNull String containerPath) {
        if (hostPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPath", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        if (containerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerPath", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath);
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public DockerComposeServiceV1Builder addVolume(@NotNull String hostPath, @NotNull String containerPath, @NotNull AccessMode accessMode) {
        if (hostPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPath", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        if (containerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerPath", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        if (accessMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMode", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath + ":" + accessMode.getCode());
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "addVolume"));
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV1Builder withVolumesFrom(DockerVolumesFrom ... volumesFrom) {
        this.myVolumesFrom = volumesFrom == null ? null : Lists.transform(Arrays.asList(volumesFrom), input -> {
            AccessMode accessMode = input.isReadOnly() ? AccessMode.RO : AccessMode.RW;
            return new DockerComposeVolumesFromV1(input.getContainerId(), accessMode);
        });
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "withVolumesFrom"));
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV1 createServiceBean() {
        DockerComposeServiceV1 dockerComposeServiceV1 = new DockerComposeServiceV1();
        if (dockerComposeServiceV1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "createServiceBean"));
        }
        return dockerComposeServiceV1;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV1 tuneServiceBean(@NotNull DockerComposeServiceV1 serviceBean) {
        if (serviceBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceBean", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "tuneServiceBean"));
        }
        serviceBean.setBuild(this.myBuild);
        serviceBean.setVolumes(this.myVolumes);
        serviceBean.setVolumesFrom(this.myVolumesFrom);
        DockerComposeServiceV1 dockerComposeServiceV1 = serviceBean;
        if (dockerComposeServiceV1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "tuneServiceBean"));
        }
        return dockerComposeServiceV1;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV1Builder getThis() {
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "getThis"));
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public static DockerComposeServiceV1Builder builder() {
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = new DockerComposeServiceV1Builder();
        if (dockerComposeServiceV1Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder", "builder"));
        }
        return dockerComposeServiceV1Builder;
    }
}

