/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v2;

import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2Builder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeVolumeV2;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerComposeConfigurationV2Builder
implements DockerComposeConfigurationBuilder<DockerComposeConfigurationV2, DockerComposeServiceV2, DockerComposeServiceV2Builder> {
    @NotNull
    private String myVersion = "2";
    private final Map<String, DockerComposeServiceV2Builder> myServices = new LinkedHashMap<String, DockerComposeServiceV2Builder>();
    private final Map<String, DockerComposeVolumeV2> myVolumes = new LinkedHashMap<String, DockerComposeVolumeV2>();

    @NotNull
    public DockerComposeConfigurationV2Builder withVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "withVersion"));
        }
        this.myVersion = version;
        DockerComposeConfigurationV2Builder dockerComposeConfigurationV2Builder = this;
        if (dockerComposeConfigurationV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "withVersion"));
        }
        return dockerComposeConfigurationV2Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV2Builder addService(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "addService"));
        }
        DockerComposeServiceV2Builder builder = new DockerComposeServiceV2Builder();
        this.myServices.put(name, builder);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = builder;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "addService"));
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeConfigurationV2Builder addVolume(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "addVolume"));
        }
        DockerComposeVolumeV2 volume = new DockerComposeVolumeV2();
        this.myVolumes.put(name, volume);
        DockerComposeConfigurationV2Builder dockerComposeConfigurationV2Builder = this;
        if (dockerComposeConfigurationV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "addVolume"));
        }
        return dockerComposeConfigurationV2Builder;
    }

    @Override
    @NotNull
    public DockerComposeConfigurationV2 build() {
        LinkedHashMap<String, DockerComposeServiceV2> services = new LinkedHashMap<String, DockerComposeServiceV2>();
        for (Map.Entry<String, DockerComposeServiceV2Builder> entry : this.myServices.entrySet()) {
            services.put(entry.getKey(), (DockerComposeServiceV2)entry.getValue().build());
        }
        DockerComposeConfigurationV2 configuration = new DockerComposeConfigurationV2(this.myVersion, services);
        if (!this.myVolumes.isEmpty()) {
            configuration.setVolumes(this.myVolumes);
        }
        DockerComposeConfigurationV2 dockerComposeConfigurationV2 = configuration;
        if (dockerComposeConfigurationV2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2Builder", "build"));
        }
        return dockerComposeConfigurationV2;
    }
}

