/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v2;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.configuration.beans.common.AccessMode;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilderBase;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeBuildV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeVolumesFromV2;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeServiceV2Builder
extends DockerComposeServiceBuilderBase<DockerComposeServiceV2Builder, DockerComposeServiceV2> {
    private DockerComposeBuildV2 myBuild;
    private List<String> myVolumes;
    private List<DockerComposeVolumesFromV2> myVolumesFrom;

    @NotNull
    public DockerComposeServiceV2Builder withBuild(@NotNull String val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withBuild"));
        }
        this.myBuild = new DockerComposeBuildV2(val);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withBuild"));
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder withBuild(@NotNull String context, @NotNull String dockerfile) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withBuild"));
        }
        if (dockerfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerfile", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withBuild"));
        }
        this.myBuild = new DockerComposeBuildV2(context, dockerfile);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withBuild"));
        }
        return dockerComposeServiceV2Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV2Builder withBindVolumes(@Nullable DockerVolumeBinding[] volumeBindings) {
        List<Object> volumeBindingsList = volumeBindings == null ? Collections.emptyList() : Arrays.asList(volumeBindings);
        this.myVolumes = Lists.transform(volumeBindingsList, (Function)new Function<DockerVolumeBinding, String>(){

            public String apply(DockerVolumeBinding volume) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!StringUtil.isEmpty((String)volume.getHostPath())) {
                    stringBuilder.append(volume.getHostPath()).append(":");
                }
                stringBuilder.append(volume.getContainerPath());
                if (!StringUtil.isEmpty((String)volume.getHostPath()) && !volume.isReadOnly()) {
                    stringBuilder.append(":").append(AccessMode.RW.getCode());
                }
                return stringBuilder.toString();
            }
        });
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withBindVolumes"));
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder addVolume(@NotNull String containerPath) {
        if (containerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerPath", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(containerPath);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder addVolume(@NotNull String hostPath, @NotNull String containerPath) {
        if (hostPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPath", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        if (containerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerPath", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder addVolume(@NotNull String hostPath, @NotNull String containerPath, @NotNull AccessMode accessMode) {
        if (hostPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPath", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        if (containerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerPath", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        if (accessMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMode", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath + ":" + accessMode.getCode());
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "addVolume"));
        }
        return dockerComposeServiceV2Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV2Builder withVolumesFrom(@Nullable DockerVolumesFrom[] volumesFrom) {
        this.myVolumesFrom = volumesFrom == null ? null : Lists.transform(Arrays.asList(volumesFrom), input -> {
            AccessMode accessMode = input.isReadOnly() ? AccessMode.RO : AccessMode.RW;
            return new DockerComposeVolumesFromV2(DockerComposeVolumesFromV2.Type.CONTAINER, input.getContainerId(), accessMode);
        });
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "withVolumesFrom"));
        }
        return dockerComposeServiceV2Builder;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV2 createServiceBean() {
        DockerComposeServiceV2 dockerComposeServiceV2 = new DockerComposeServiceV2();
        if (dockerComposeServiceV2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "createServiceBean"));
        }
        return dockerComposeServiceV2;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV2 tuneServiceBean(@NotNull DockerComposeServiceV2 serviceBean) {
        if (serviceBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceBean", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "tuneServiceBean"));
        }
        serviceBean.setBuild(this.myBuild);
        serviceBean.setVolumes(this.myVolumes);
        serviceBean.setVolumesFrom(this.myVolumesFrom);
        DockerComposeServiceV2 dockerComposeServiceV2 = serviceBean;
        if (dockerComposeServiceV2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "tuneServiceBean"));
        }
        return dockerComposeServiceV2;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV2Builder getThis() {
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "getThis"));
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public static DockerComposeServiceV2Builder builder() {
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = new DockerComposeServiceV2Builder();
        if (dockerComposeServiceV2Builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder", "builder"));
        }
        return dockerComposeServiceV2Builder;
    }
}

