/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DockerComposeConfigurationUtil {
    private static final List<String> DOCKER_COMPOSE_SUPPORTED_FILENAMES = ImmutableList.of((Object)"docker-compose.yml", (Object)"docker-compose.yaml");
    private static final String DOCKER_COMPOSE_OVERRIDE_FILENAME = "docker-compose.override.yml";
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";

    private DockerComposeConfigurationUtil() {
    }

    @NotNull
    public static List<Path> findConfigurationFiles(@NotNull List<String> configurationPathnames) throws FileNotFoundException {
        if (configurationPathnames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationPathnames", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findConfigurationFiles"));
        }
        if (configurationPathnames.isEmpty()) {
            throw new IllegalArgumentException("Configuration path name list must not be empty");
        }
        String mainConfigurationPathname = configurationPathnames.get(0);
        if (Files.isDirectory(Paths.get(mainConfigurationPathname, new String[0]), new LinkOption[0])) {
            List<Path> list = DockerComposeConfigurationUtil.findConfigurationFiles(mainConfigurationPathname);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findConfigurationFiles"));
            }
            return list;
        }
        List<Path> list = Stream.concat(Stream.of(Paths.get(mainConfigurationPathname, new String[0])), configurationPathnames.stream().skip(1L).map(pathname -> Paths.get(pathname, new String[0])).filter(path -> Files.exists(path, new LinkOption[0]))).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findConfigurationFiles"));
        }
        return list;
    }

    @NotNull
    public static List<Path> findConfigurationFiles(@NotNull String configurationPathname) throws FileNotFoundException {
        if (configurationPathname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationPathname", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findConfigurationFiles"));
        }
        Path path = Paths.get(configurationPathname, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Path configurationPath = DockerComposeConfigurationUtil.findDockerComposeConfigurationPath(path);
            builder.add((Object)configurationPath);
            Path overrideConfiguration = configurationPath.resolveSibling(DOCKER_COMPOSE_OVERRIDE_FILENAME);
            if (Files.isRegularFile(overrideConfiguration, new LinkOption[0])) {
                builder.add((Object)overrideConfiguration);
            }
            ImmutableList immutableList = builder.build();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findConfigurationFiles"));
            }
            return immutableList;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            List<Path> list = Collections.singletonList(path);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findConfigurationFiles"));
            }
            return list;
        }
        throw new FileNotFoundException(String.format("Neither folder nor file \"%s\" exists", path));
    }

    @NotNull
    private static Path findDockerComposeConfigurationPath(@NotNull Path folder) throws FileNotFoundException {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findDockerComposeConfigurationPath"));
        }
        for (String filename : DOCKER_COMPOSE_SUPPORTED_FILENAMES) {
            Path configurationPath = folder.resolve(filename);
            if (!Files.isRegularFile(configurationPath, new LinkOption[0])) continue;
            Path path = configurationPath;
            if (path == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "findDockerComposeConfigurationPath"));
            }
            return path;
        }
        throw new FileNotFoundException(String.format("Can't find a suitable configuration file in this directory. Supported filenames: %s", Joiner.on((String)", ").join(DOCKER_COMPOSE_SUPPORTED_FILENAMES)));
    }

    @NotNull
    public static String getDockerComposeProjectName(@NotNull Path composeFilePath) {
        if (composeFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "composeFilePath", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "getDockerComposeProjectName"));
        }
        Path parent = composeFilePath.toAbsolutePath().getParent();
        if (parent == null || parent.getFileName() == null) {
            if (DEFAULT_DOCKER_COMPOSE_PROJECT_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "getDockerComposeProjectName"));
            }
            return DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
        }
        String string = parent.getFileName().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "getDockerComposeProjectName"));
        }
        return string;
    }

    public static boolean isNamedVolumeBind(@NotNull String bindPath) {
        if (bindPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindPath", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil", "isNamedVolumeBind"));
        }
        return !(bindPath = bindPath.trim()).isEmpty() && !bindPath.startsWith("/") && !bindPath.startsWith("~") && !bindPath.startsWith(".");
    }
}

