/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.util;

import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeEnvFile;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeBuildV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeExtendsV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.remote.run.common.PathsBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DockerComposeConfigurationVolumesCollector {
    private static final Logger LOG = Logger.getInstance(DockerComposeConfigurationVolumesCollector.class);
    private static final List<String> BUILD_URL_PREFIXES = ContainerUtil.newArrayList((Object[])new String[]{"http://", "https://", "git://", "github.com/", "git@"});
    @NotNull
    private final PathsBuilder myPathsBuilder;
    @NotNull
    private final Set<Path> myProcessedPaths;
    private final DockerComposeConfigurationParser myParser;

    public DockerComposeConfigurationVolumesCollector(@NotNull PathsBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "<init>"));
        }
        this.myProcessedPaths = new LinkedHashSet<Path>();
        this.myParser = new DockerComposeConfigurationParser();
        this.myPathsBuilder = builder;
    }

    public void collect(@NotNull List<String> configurationFilePaths) throws IOException {
        if (configurationFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFilePaths", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "collect"));
        }
        Path[] paths = new Path[configurationFilePaths.size()];
        for (int i = 0; i < configurationFilePaths.size(); ++i) {
            paths[i] = Paths.get(configurationFilePaths.get(i), new String[0]);
        }
        this.collect(paths);
    }

    public void collect(Path ... configurationFilePaths) throws IOException {
        if (configurationFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFilePaths", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "collect"));
        }
        Path mainConfigurationFilePath = configurationFilePaths[0].toAbsolutePath();
        final Path mainConfigurationFolderPath = mainConfigurationFilePath.getParent();
        for (Path configurationFilePath : configurationFilePaths) {
            Path absolutePath = configurationFilePath.toAbsolutePath();
            final Path configurationFolderPath = absolutePath.getParent();
            if (this.myProcessedPaths.contains(absolutePath)) {
                return;
            }
            this.myProcessedPaths.add(absolutePath);
            this.myPathsBuilder.addPath(DockerUtil.toUnixPath(configurationFolderPath.toString()));
            DockerComposeConfiguration configuration = this.myParser.parseBean(configurationFilePath.toString());
            List<Path> otherConfigurations = configuration.accept(new DockerComposeConfiguration.Visitor<List<Path>>(){

                @Override
                public List<Path> visit(@NotNull DockerComposeConfigurationV1 configuration) {
                    if (configuration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector$1", "visit"));
                    }
                    for (Map.Entry<String, DockerComposeServiceV1> service : configuration.getServices().entrySet()) {
                        DockerComposeEnvFile envFile;
                        String buildDir = service.getValue().getBuild();
                        if (StringUtil.isNotEmpty((String)buildDir)) {
                            DockerComposeConfigurationVolumesCollector.this.processBuildDir(mainConfigurationFolderPath.toString(), buildDir);
                        }
                        if ((envFile = service.getValue().getEnvFile()) == null || envFile.getEnvFiles() == null) continue;
                        for (String file : envFile.getEnvFiles()) {
                            DockerComposeConfigurationVolumesCollector.this.processEnvFile(mainConfigurationFolderPath.toString(), file);
                        }
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Path> visit(@NotNull DockerComposeConfigurationV2 configuration) {
                    if (configuration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector$1", "visit"));
                    }
                    ArrayList<Path> result = new ArrayList<Path>();
                    for (Map.Entry<String, DockerComposeServiceV2> service : configuration.getServices().entrySet()) {
                        DockerComposeExtendsV2 serviceExtends;
                        DockerComposeEnvFile envFile;
                        String context;
                        DockerComposeServiceV2 serviceContent = service.getValue();
                        if (serviceContent == null) continue;
                        DockerComposeBuildV2 build = serviceContent.getBuild();
                        if (build != null && StringUtil.isNotEmpty((String)(context = build.getContext()))) {
                            DockerComposeConfigurationVolumesCollector.this.processBuildDir(mainConfigurationFolderPath.toString(), context);
                        }
                        if ((envFile = serviceContent.getEnvFile()) != null && envFile.getEnvFiles() != null) {
                            for (String file : envFile.getEnvFiles()) {
                                DockerComposeConfigurationVolumesCollector.this.processEnvFile(mainConfigurationFolderPath.toString(), file);
                            }
                        }
                        if ((serviceExtends = serviceContent.getExtends()) == null || !StringUtil.isNotEmpty((String)serviceExtends.getFile())) continue;
                        result.add(Paths.get(configurationFolderPath.toString(), serviceExtends.getFile()));
                    }
                    return result;
                }
            });
            for (Path otherConfigurationFilePath : otherConfigurations) {
                this.collect(otherConfigurationFilePath);
            }
        }
    }

    private void processBuildDir(@NotNull String configurationFolderPath, @NotNull String buildDir) {
        if (configurationFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFolderPath", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "processBuildDir"));
        }
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "processBuildDir"));
        }
        if (DockerComposeConfigurationVolumesCollector.isGitUrl(buildDir)) {
            LOG.debug("Build source will be taken by Docker Compose from URL: ", new Object[]{buildDir});
        } else if (FileUtil.isAbsolutePlatformIndependent((String)buildDir)) {
            this.myPathsBuilder.addPath(buildDir);
        } else {
            this.myPathsBuilder.addPath(FilenameUtils.concat((String)configurationFolderPath, (String)buildDir));
        }
    }

    private void processEnvFile(@NotNull String configurationFolderPath, @NotNull String envFile) {
        if (configurationFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFolderPath", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "processEnvFile"));
        }
        if (envFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envFile", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "processEnvFile"));
        }
        String resolvedPath = FileUtil.isUnixAbsolutePath((String)envFile) ? envFile : FilenameUtils.concat((String)configurationFolderPath, (String)envFile);
        String parent = PathUtil.getParentPath((String)resolvedPath);
        if (StringUtil.isNotEmpty((String)parent)) {
            this.myPathsBuilder.addPath(parent);
        }
    }

    @Contract(pure=true)
    private static boolean isGitUrl(@NotNull String buildDir) {
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationVolumesCollector", "isGitUrl"));
        }
        for (String prefix : BUILD_URL_PREFIXES) {
            if (!buildDir.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

