/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service;

import com.intellij.docker.compose.DockerComposeClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmdExec;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmdExec;
import org.jetbrains.annotations.NotNull;

public class DockerComposeServiceClient {
    @NotNull
    private final DockerComposeClient myDockerComposeClient;

    public DockerComposeServiceClient(@NotNull DockerComposeClient client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/docker/compose/service/DockerComposeServiceClient", "<init>"));
        }
        this.myDockerComposeClient = client;
    }

    @NotNull
    public ComposeServiceRunCmd runServiceCmd() {
        ComposeServiceRunCmd composeServiceRunCmd = new ComposeServiceRunCmd(new ComposeServiceRunCmdExec(this.myDockerComposeClient));
        if (composeServiceRunCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/DockerComposeServiceClient", "runServiceCmd"));
        }
        return composeServiceRunCmd;
    }

    @NotNull
    public ComposeServiceUpCmd upServicesCmd() {
        ComposeServiceUpCmd composeServiceUpCmd = new ComposeServiceUpCmd(new ComposeServiceUpCmdExec(this.myDockerComposeClient));
        if (composeServiceUpCmd == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/DockerComposeServiceClient", "upServicesCmd"));
        }
        return composeServiceUpCmd;
    }

    @NotNull
    public static DockerComposeServiceClient getInstance(@NotNull DockerComposeClient client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/docker/compose/service/DockerComposeServiceClient", "getInstance"));
        }
        DockerComposeServiceClient dockerComposeServiceClient = new DockerComposeServiceClient(client);
        if (dockerComposeServiceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/DockerComposeServiceClient", "getInstance"));
        }
        return dockerComposeServiceClient;
    }
}

