/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.docker.compose.DockerComposeClient;
import com.intellij.docker.compose.DockerComposeProjectService;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationSerializer;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmdResult;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.WrappedNotModifiedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class ComposeServiceUpCmdExec {
    private static final String DOCKER_COMPOSE_UP_CMD_TITLE = "docker-compose up";
    private static final Logger LOG = Logger.getInstance(ComposeServiceUpCmdExec.class);
    @NotNull
    private final DockerComposeClient myDockerComposeClient;

    public ComposeServiceUpCmdExec(@NotNull DockerComposeClient client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "<init>"));
        }
        this.myDockerComposeClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ComposeServiceUpCmdResult exec(@NotNull ComposeServiceUpCmd cmd) throws IOException, InterruptedException, ServerRuntimeException {
        DockerExecProcess targetServiceProcess;
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "exec"));
        }
        if (ContainerUtil.isEmpty(cmd.getConfigurationPaths())) {
            throw new IllegalArgumentException("Compose configuration path must be defined");
        }
        if (StringUtil.isEmpty((String)cmd.getServiceName())) {
            throw new IllegalArgumentException("Compose service name must be defined");
        }
        List<Path> paths = DockerComposeConfigurationUtil.findConfigurationFiles(cmd.getConfigurationPaths());
        Path mainConfigurationPath = paths.iterator().next();
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(cmd.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(mainConfigurationPath, namedVolumes);
        configurationBuilder.addService(cmd.getServiceName()).withCommand(cmd.getCommand()).withWorkingDir(cmd.getWorkingDir()).withEnvironment(cmd.getEnvironment()).withVolumesFrom(cmd.getVolumesFrom()).withBindVolumes(cmd.getVolumesBinding()).withPorts(cmd.getPorts()).withUser(cmd.getUser()).withRestartPolicy(cmd.getRestartPolicy()).withStdinOpen(true);
        Object override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.createTempDockerComposeOverrideYml();
        try (FileWriter output = new FileWriter(tempFile);){
            DockerComposeConfigurationSerializer.newInstance().serialize(output, (DockerComposeConfiguration)override);
        }
        RemoteDockerApplicationRuntime applicationRuntime = this.myDockerComposeClient.createUpContainer().withConfigurationFiles((List<Path>)ImmutableList.builder().addAll(paths).add((Object)tempFile.toPath()).build()).withEnvs(cmd.getEnvs()).exec();
        SettableFuture<DockerExecProcess> targetServiceFuture = this.up(mainConfigurationPath, cmd, applicationRuntime, DOCKER_COMPOSE_UP_CMD_TITLE);
        try {
            targetServiceProcess = (DockerExecProcess)((Object)targetServiceFuture.get());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        if (targetServiceProcess == null) {
            LOG.warn("Failed to locate container name for service \"" + cmd.getServiceName() + "\" in docker-compose output");
            throw new IllegalStateException("Unable to locate container name for service \"" + cmd.getServiceName() + "\" from docker-compose output");
        }
        ComposeServiceUpCmdResult composeServiceUpCmdResult = new ComposeServiceUpCmdResult(targetServiceProcess);
        if (composeServiceUpCmdResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "exec"));
        }
        return composeServiceUpCmdResult;
    }

    @NotNull
    private SettableFuture<DockerExecProcess> up(final @NotNull Path mainConfigurationPath, final @NotNull AbstractServiceCmd<?> cmd, final @NotNull RemoteDockerApplicationRuntime applicationRuntime, final @NotNull String title) {
        if (mainConfigurationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainConfigurationPath", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "up"));
        }
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "up"));
        }
        if (applicationRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "up"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "up"));
        }
        final SettableFuture resultFuture = SettableFuture.create();
        Task.Modal task = new Task.Modal(null, title, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec$1", "run"));
                }
                final AtomicBoolean progressCancelled = new AtomicBoolean(false);
                ProcessOutput processOutput = new ProcessOutput();
                try {
                    final Thread currentThread = Thread.currentThread();
                    if (indicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                            public void cancel() {
                                progressCancelled.set(true);
                                currentThread.interrupt();
                            }
                        });
                    }
                    DockerComposeProjectService.getInstance().runDockerComposeContainer(mainConfigurationPath, () -> {
                        block51: {
                            if (applicationRuntime == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec$1", "lambda$run$0"));
                            }
                            if (cmd == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec$1", "lambda$run$0"));
                            }
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec$1", "lambda$run$0"));
                            }
                            try {
                                DockerExecProcess process = DockerExecProcess.Factory.startProcessWithRemove(applicationRuntime);
                                try (Scanner stdout = new Scanner(process.getInputStream());
                                     PrintWriter stdin = new PrintWriter(process.getOutputStream(), true);){
                                    try {
                                        DockerExecProcess targetServiceProcess = null;
                                        while (stdout.hasNextLine()) {
                                            RemoteDockerApplicationRuntime currentContainer;
                                            String line = stdout.nextLine();
                                            processOutput.appendStdout(line);
                                            String currentContainerName = ServiceCmdExecUtils.parseDockerStartCmd(line);
                                            RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = currentContainer = currentContainerName == null ? null : applicationRuntime.getDockerRuntime().findContainerByName(currentContainerName);
                                            if (currentContainer != null) {
                                                boolean thisIsTargetService = false;
                                                if (ServiceCmdExecUtils.isServiceContainer(currentContainer, cmd.getServiceName())) {
                                                    if (targetServiceProcess == null) {
                                                        LOG.debug("Primary service container found {" + currentContainerName + "}");
                                                        thisIsTargetService = true;
                                                    } else {
                                                        LOG.warn("Ambiguous primary service container found {" + currentContainerName + "}");
                                                    }
                                                }
                                                LOG.debug("Starting service container {" + currentContainerName + "}");
                                                try {
                                                    if (thisIsTargetService) {
                                                        currentContainer.attach();
                                                    }
                                                    currentContainer.start();
                                                    if (!thisIsTargetService) continue;
                                                    targetServiceProcess = DockerExecProcess.Factory.newProcess(currentContainer, false);
                                                    resultFuture.set((Object)targetServiceProcess);
                                                    continue;
                                                }
                                                catch (WrappedNotModifiedException e) {
                                                    if (!thisIsTargetService) continue;
                                                    resultFuture.setException((Throwable)new RemoteSdkException("Service \"" + cmd.getServiceName() + "\" already started"));
                                                    process.destroy();
                                                    continue;
                                                }
                                                finally {
                                                    stdin.println();
                                                    continue;
                                                }
                                            }
                                            indicator.setText2(line);
                                        }
                                    }
                                    finally {
                                        stdin.close();
                                    }
                                }
                                finally {
                                    process.destroy();
                                }
                                try {
                                    processOutput.appendStderr(IOUtils.toString((InputStream)process.getErrorStream()));
                                }
                                catch (IOException stdout) {}
                            }
                            catch (ServerRuntimeException e) {
                                if (!resultFuture.setException((Throwable)e)) {
                                    LOG.debug((Throwable)e);
                                    String message = ServiceCmdExecUtils.extractErrorMessage(e);
                                    DockerUtil.NOTIFICATIONS.createNotification(message, MessageType.ERROR).notify(this.getProject());
                                }
                            }
                            catch (RemoteSdkException e) {
                                if (resultFuture.setException((Throwable)e)) break block51;
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
                finally {
                    if (!resultFuture.isDone()) {
                        if (progressCancelled.get()) {
                            resultFuture.setException((Throwable)new RuntimeException(title + " process cancelled"));
                        } else {
                            ServiceCmdExecUtils.ServiceContainers serviceContainers = ServiceCmdExecUtils.listServiceContainerNames(processOutput);
                            Optional<String> serviceContainerName = ServiceCmdExecUtils.tryFindServiceContainerName(serviceContainers, cmd.getServiceName());
                            if (serviceContainerName.isPresent()) {
                                resultFuture.setException((Throwable)new RuntimeException("Cannot attach to already running service \"" + cmd.getServiceName() + "\""));
                            } else {
                                resultFuture.set(null);
                            }
                        }
                    } else if (progressCancelled.get()) {
                        LOG.debug("docker-compose process cancelled after target service " + cmd.getServiceName() + " has been started");
                    }
                }
            }
        };
        if (ProgressManager.getInstance().hasProgressIndicator()) {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> ProgressManager.getInstance().run((Task)task), ModalityState.any());
        }
        SettableFuture settableFuture = resultFuture;
        if (settableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ComposeServiceUpCmdExec", "up"));
        }
        return settableFuture;
    }
}

