/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.remote.DockerComposeCredentialsEditorLanguageContribution;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeCredentialsEditor
implements CredentialsEditor<DockerComposeCredentialsHolder>,
PanelWithAnchor {
    private static final Logger LOG = Logger.getInstance(DockerComposeCredentialsEditor.class);
    private static final List<String> DOCKER_COMPOSE_YML = ImmutableList.of((Object)"docker-compose.yml", (Object)"docker-compose.yaml");
    private static final String DOCKER_COMPOSE_OVERRIDE_YML = "docker-compose.override.yml";
    private JPanel myMainPanel;
    private JPanel myDockerAccountSelectionPlaceHolder;
    private ComboBox<String> myDockerComposeServiceNameComboBox;
    private EnvironmentVariablesComponent myEnvsComponent;
    private JPanel myConfigurationFilesPanel;
    private JBLabel myConfigurationFilesLabel;
    private JBList<String> myConfigurationFilesList;
    @Nullable
    private final Project myProject;
    @NotNull
    private final StatusPanel myStatusPanel;
    @Nullable
    private final DockerComposeCredentialsEditorLanguageContribution<?> myEditorLanguageContribution;
    private final CloudAccountSelectionEditor myDockerAccountSelectionEditor;
    private boolean myConfigurationPathShouldBeInitialized;
    private String myConfigurationError;
    private boolean myValidationPhase;
    private DefaultListModel<String> myConfigurationFilesModel;
    @Nullable
    private JComponent myAnchor;

    public DockerComposeCredentialsEditor(@Nullable Project project, @NotNull CredentialsLanguageContribution languageContribution, @NotNull StatusPanel statusPanel) {
        if (languageContribution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageContribution", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "<init>"));
        }
        if (statusPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusPanel", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "<init>"));
        }
        this.myConfigurationPathShouldBeInitialized = true;
        this.myProject = project;
        this.myStatusPanel = statusPanel;
        this.$$$setupUI$$$();
        this.myEditorLanguageContribution = DockerComposeCredentialsEditor.findEditorContribution(languageContribution);
        this.myDockerAccountSelectionEditor = new CloudAccountSelectionEditor(Collections.singletonList(DockerCloudType.getInstance()));
        this.myDockerAccountSelectionPlaceHolder.add(this.myDockerAccountSelectionEditor.getMainPanel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceNameComboBox() {
        StatusPanel.Action action = this.myStatusPanel.progress("Processing Docker Compose configuration...");
        CollectionComboBoxModel model = new CollectionComboBoxModel();
        this.myConfigurationError = null;
        try {
            if (this.myEditorLanguageContribution != null) {
                ArrayList<String> configurationFilePaths = new ArrayList<String>();
                for (int i = 0; i < this.myConfigurationFilesList.getModel().getSize(); ++i) {
                    String configurationFile = (String)this.myConfigurationFilesList.getModel().getElementAt(i);
                    if (Files.exists(Paths.get(configurationFile, new String[0]), new LinkOption[0])) {
                        configurationFilePaths.add(configurationFile);
                        continue;
                    }
                    if (i != 0) continue;
                    throw new FileNotFoundException(String.format("Base configuration file \"%s\" does not exist", configurationFile));
                }
                DockerComposeCredentialsEditorLanguageContribution.DockerComposeConfigurationInfo info = this.myEditorLanguageContribution.getDockerComposeConfigurationInfo(configurationFilePaths);
                ArrayList<String> services = new ArrayList<String>(info.getServices());
                services.sort(String.CASE_INSENSITIVE_ORDER);
                model = new CollectionComboBoxModel(services);
                action.done();
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug((Throwable)e);
            this.myConfigurationError = e.getMessage();
            if (!this.myValidationPhase) {
                action.failed(this.myConfigurationError);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.debug((Throwable)e);
            this.myConfigurationError = e.getMessage();
            if (!this.myValidationPhase) {
                action.failed(this.myConfigurationError);
            }
        }
        finally {
            this.myDockerComposeServiceNameComboBox.setModel((ComboBoxModel)model);
            action.done();
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void onSelected() {
        if (this.myProject != null && this.myConfigurationPathShouldBeInitialized) {
            try {
                if (this.myProject.getBasePath() != null) {
                    List<String> configurationFiles = DockerComposeCredentialsEditor.getConfigurationFilesFromDir(this.myProject.getBasePath(), false);
                    configurationFiles.forEach(path -> this.myConfigurationFilesModel.addElement((String)path));
                }
            }
            finally {
                this.myConfigurationPathShouldBeInitialized = false;
            }
        }
    }

    public ValidationInfo validate() {
        this.myValidationPhase = true;
        RemoteServer selectedAccount = this.myDockerAccountSelectionEditor.getSelectedAccount();
        if (selectedAccount == null) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("Docker server is not selected", this.myDockerAccountSelectionEditor.getMainPanel());
        }
        if (this.myConfigurationFilesModel.isEmpty()) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("Configuration files are not chosen", this.myConfigurationFilesList);
        }
        if (StringUtil.isNotEmpty((String)this.myConfigurationError)) {
            this.myStatusPanel.resetState();
            return new ValidationInfo(this.myConfigurationError, this.myConfigurationFilesList);
        }
        if (this.myDockerComposeServiceNameComboBox.getItemCount() == 0) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("No services defined in the configuration file(s)", this.myDockerComposeServiceNameComboBox);
        }
        String serviceName = (String)this.myDockerComposeServiceNameComboBox.getSelectedItem();
        if (StringUtil.isEmpty((String)serviceName)) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("Service name is not selected", this.myDockerComposeServiceNameComboBox);
        }
        return null;
    }

    private void createUIComponents() {
        this.myConfigurationFilesModel = new DefaultListModel();
        this.myConfigurationFilesList = new JBList(this.myConfigurationFilesModel);
        this.myConfigurationFilesPanel = ToolbarDecorator.createDecorator(this.myConfigurationFilesList).setAddAction(button -> this.addConfigurationFileItem()).setRemoveAction(button -> this.deleteConfigurationFileItems()).createPanel();
        this.myConfigurationFilesModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                DockerComposeCredentialsEditor.this.updateServiceNameComboBox();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                DockerComposeCredentialsEditor.this.updateServiceNameComboBox();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                DockerComposeCredentialsEditor.this.updateServiceNameComboBox();
            }
        });
    }

    private void addConfigurationFileItem() {
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, false, true, false, false).withTitle("Choose Configuration File or Folder");
        VirtualFile toSelect = this.myProject == null ? null : this.myProject.getBaseDir();
        FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)this.myProject, this.myConfigurationFilesList, (VirtualFile)toSelect, this::onConfigurationFileChosen);
    }

    private void onConfigurationFileChosen(VirtualFile file) {
        if (file.isDirectory()) {
            List<String> files = DockerComposeCredentialsEditor.getConfigurationFilesFromDir(file.getPath(), false);
            files.forEach(configurationFile -> this.myConfigurationFilesModel.addElement((String)configurationFile));
        } else {
            this.myConfigurationFilesModel.addElement(file.getPath());
        }
        this.updateServiceNameComboBox();
    }

    private void deleteConfigurationFileItems() {
        ListUtil.removeSelectedItems(this.myConfigurationFilesList);
        this.updateServiceNameComboBox();
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myConfigurationFilesLabel.setAnchor(anchor);
        this.myEnvsComponent.setAnchor(anchor);
        this.myEnvsComponent.invalidate();
    }

    @Nullable
    private static DockerComposeCredentialsEditorLanguageContribution<?> findEditorContribution(@NotNull CredentialsLanguageContribution languageContribution) {
        if (languageContribution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageContribution", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "findEditorContribution"));
        }
        for (DockerComposeCredentialsEditorLanguageContribution o : (DockerComposeCredentialsEditorLanguageContribution[])DockerComposeCredentialsEditorLanguageContribution.EP_NAME.getExtensions()) {
            if (o.getLanguageContribution() != languageContribution) continue;
            return o;
        }
        return null;
    }

    public void saveCredentials(DockerComposeCredentialsHolder credentials) {
        RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
        String accountName = account == null ? null : account.getName();
        credentials.setAccountName(accountName);
        ArrayList<String> composeFilePaths = new ArrayList<String>();
        for (int i = 0; i < this.myConfigurationFilesModel.size(); ++i) {
            composeFilePaths.add(this.myConfigurationFilesModel.get(i));
        }
        credentials.setComposeFilePaths(composeFilePaths);
        credentials.setComposeServiceName((String)this.myDockerComposeServiceNameComboBox.getSelectedItem());
        credentials.setRemoteProjectPath("/opt/project");
        credentials.setEnvs(this.myEnvsComponent.getEnvData());
    }

    public void init(DockerComposeCredentialsHolder credentials) {
        this.myConfigurationPathShouldBeInitialized = false;
        this.myDockerAccountSelectionEditor.setSelectedAccount(credentials.getAccountName());
        this.initComposeFilePaths(credentials);
        this.myDockerComposeServiceNameComboBox.setSelectedItem((Object)credentials.getComposeServiceName());
        this.myEnvsComponent.setEnvData(credentials.getEnvs());
    }

    private void initComposeFilePaths(@NotNull DockerComposeCredentialsHolder credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "initComposeFilePaths"));
        }
        String mainConfiguration = (String)ContainerUtil.getFirstItem(credentials.getComposeFilePaths());
        List<String> paths = StringUtil.isNotEmpty((String)mainConfiguration) && Files.isDirectory(Paths.get(mainConfiguration, new String[0]), new LinkOption[0]) ? DockerComposeCredentialsEditor.getConfigurationFilesFromDir(mainConfiguration, true) : credentials.getComposeFilePaths();
        paths.forEach(path -> this.myConfigurationFilesModel.addElement((String)path));
    }

    @NotNull
    private static List<String> getConfigurationFilesFromDir(@NotNull String configurationDir, boolean withDefault) {
        if (configurationDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationDir", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "getConfigurationFilesFromDir"));
        }
        ArrayList<String> configurationFiles = new ArrayList<String>();
        String mainConfigurationFile = DockerComposeCredentialsEditor.getMainConfigurationFile(configurationDir, withDefault);
        if (mainConfigurationFile != null) {
            configurationFiles.add(mainConfigurationFile);
            Path overrideConfigurationPath = Paths.get(configurationDir, DOCKER_COMPOSE_OVERRIDE_YML);
            if (Files.exists(overrideConfigurationPath, new LinkOption[0])) {
                configurationFiles.add(overrideConfigurationPath.toString());
            }
        }
        ArrayList<String> arrayList = configurationFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "getConfigurationFilesFromDir"));
        }
        return arrayList;
    }

    @Nullable
    private static String getMainConfigurationFile(@NotNull String configurationDir, boolean withDefault) {
        if (configurationDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationDir", "com/intellij/docker/remote/DockerComposeCredentialsEditor", "getMainConfigurationFile"));
        }
        for (String fileName : DOCKER_COMPOSE_YML) {
            Path path = Paths.get(configurationDir, fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return path.toString();
        }
        return withDefault ? Paths.get(configurationDir, DOCKER_COMPOSE_YML.get(0)).toString() : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        EnvironmentVariablesComponent environmentVariablesComponent;
        ComboBox comboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Server:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myDockerAccountSelectionPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Service:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerComposeServiceNameComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myEnvsComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText("&Environment variables");
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = this.myConfigurationFilesPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConfigurationFilesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Configuration file(s):");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

