/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DockerComposeCredentialsEditorLanguageContribution<T extends CredentialsLanguageContribution> {
    public static final ExtensionPointName<DockerComposeCredentialsEditorLanguageContribution> EP_NAME = ExtensionPointName.create((String)"com.intellij.docker.remote.dockerComposeCredentialsEditorLanguageContribution");

    @NotNull
    public abstract DockerComposeConfigurationInfo getDockerComposeConfigurationInfo(@NotNull List<String> var1) throws IOException;

    @NotNull
    public abstract T getLanguageContribution();

    public static class DockerComposeConfigurationInfo {
        @NotNull
        private final List<Path> myConfigurationFiles;
        @NotNull
        private final Set<String> myServices;

        public DockerComposeConfigurationInfo(@NotNull List<Path> files, @NotNull Set<String> services) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/docker/remote/DockerComposeCredentialsEditorLanguageContribution$DockerComposeConfigurationInfo", "<init>"));
            }
            if (services == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "com/intellij/docker/remote/DockerComposeCredentialsEditorLanguageContribution$DockerComposeConfigurationInfo", "<init>"));
            }
            this.myConfigurationFiles = Collections.unmodifiableList(new ArrayList<Path>(files));
            this.myServices = Collections.unmodifiableSet(new LinkedHashSet<String>(services));
        }

        @NotNull
        public List<Path> getConfigurationFiles() {
            List<Path> list = this.myConfigurationFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerComposeCredentialsEditorLanguageContribution$DockerComposeConfigurationInfo", "getConfigurationFiles"));
            }
            return list;
        }

        @NotNull
        public Set<String> getServices() {
            Set<String> set = this.myServices;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerComposeCredentialsEditorLanguageContribution$DockerComposeConfigurationInfo", "getServices"));
            }
            return set;
        }
    }
}

