/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeCredentialsHolder {
    public static final String DOCKER_ACCOUNT_NAME = "DOCKER_ACCOUNT_NAME";
    public static final String DOCKER_COMPOSE_FILE_PATH = "DOCKER_COMPOSE_FILE_PATH";
    public static final String DOCKER_COMPOSE_SERVICE_NAME = "DOCKER_COMPOSE_SERVICE_NAME";
    public static final String DOCKER_REMOTE_PROJECT_PATH = "DOCKER_REMOTE_PROJECT_PATH";
    private static final String DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG = "dockerComposeConfigurationPaths";
    private static final String ITEM_TAG = "item";
    private static final String VALUE_ATTRIBUTE = "value";
    private String myAccountName;
    private List<String> myComposeFilePaths;
    private String myComposeServiceName;
    private String myRemoteProjectPath;
    @NotNull
    private EnvironmentVariablesData myEnvs = EnvironmentVariablesData.DEFAULT;

    public String getAccountName() {
        return this.myAccountName;
    }

    public void setAccountName(String accountName) {
        this.myAccountName = accountName;
    }

    public List<String> getComposeFilePaths() {
        return this.myComposeFilePaths;
    }

    public void setComposeFilePaths(List<String> composeFilePaths) {
        this.myComposeFilePaths = composeFilePaths;
    }

    public String getComposeServiceName() {
        return this.myComposeServiceName;
    }

    public void setComposeServiceName(String composeServiceName) {
        this.myComposeServiceName = composeServiceName;
    }

    public String getRemoteProjectPath() {
        return this.myRemoteProjectPath;
    }

    public void setRemoteProjectPath(String remoteProjectPath) {
        this.myRemoteProjectPath = remoteProjectPath;
    }

    @NotNull
    public EnvironmentVariablesData getEnvs() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvs;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerComposeCredentialsHolder", "getEnvs"));
        }
        return environmentVariablesData;
    }

    public void setEnvs(@NotNull EnvironmentVariablesData envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/docker/remote/DockerComposeCredentialsHolder", "setEnvs"));
        }
        this.myEnvs = envs;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/remote/DockerComposeCredentialsHolder", "save"));
        }
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_ACCOUNT_NAME, this.myAccountName);
        if (this.myComposeFilePaths != null) {
            Element configurationsTag = new Element(DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG);
            for (String path : this.myComposeFilePaths) {
                Element itemElement = new Element(ITEM_TAG);
                itemElement.setAttribute(VALUE_ATTRIBUTE, path);
                configurationsTag.addContent(itemElement);
            }
            element.addContent(configurationsTag);
        }
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_COMPOSE_SERVICE_NAME, this.myComposeServiceName);
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_REMOTE_PROJECT_PATH, this.myRemoteProjectPath);
        this.myEnvs.writeExternal(element);
    }

    private static void setAttribute(@NotNull Element element, @NotNull String name, @Nullable String value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/remote/DockerComposeCredentialsHolder", "setAttribute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/docker/remote/DockerComposeCredentialsHolder", "setAttribute"));
        }
        if (StringUtil.isNotEmpty((String)value)) {
            element.setAttribute(name, value);
        }
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/remote/DockerComposeCredentialsHolder", "load"));
        }
        this.myAccountName = element.getAttributeValue(DOCKER_ACCOUNT_NAME);
        String composeFilePath = element.getAttributeValue(DOCKER_COMPOSE_FILE_PATH);
        this.myComposeFilePaths = new ArrayList<String>();
        if (composeFilePath != null) {
            this.myComposeFilePaths.add(composeFilePath);
        } else {
            Element configurationPathsTag = element.getChild(DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG);
            if (configurationPathsTag != null) {
                for (Element item : configurationPathsTag.getChildren(ITEM_TAG)) {
                    String value = item.getAttributeValue(VALUE_ATTRIBUTE);
                    if (!StringUtil.isNotEmpty((String)value)) continue;
                    this.myComposeFilePaths.add(value);
                }
            }
        }
        this.myComposeServiceName = element.getAttributeValue(DOCKER_COMPOSE_SERVICE_NAME);
        this.myRemoteProjectPath = element.getAttributeValue(DOCKER_REMOTE_PROJECT_PATH);
        this.myEnvs = EnvironmentVariablesData.readExternal((Element)element);
    }
}

