/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCredentialsHolder {
    public static final String DOCKER_ACCOUNT_NAME = "DOCKER_ACCOUNT_NAME";
    public static final String DOCKER_IMAGE_NAME = "DOCKER_IMAGE_NAME";
    public static final String DOCKER_CONTAINER_NAME = "DOCKER_CONTAINER_NAME";
    public static final String DOCKER_REMOTE_PROJECT_PATH = "DOCKER_REMOTE_PROJECT_PATH";
    private String myAccountName;
    @NotNull
    private String myImageName;
    private String myContainerName;
    private String myRemoteProjectPath;

    public DockerCredentialsHolder() {
        this.myImageName = "";
    }

    public DockerCredentialsHolder(String accountName, @NotNull String imageName, String containerName, String remoteProjectPath) {
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/intellij/docker/remote/DockerCredentialsHolder", "<init>"));
        }
        this.myAccountName = accountName;
        this.myImageName = imageName;
        this.myContainerName = containerName;
        this.myRemoteProjectPath = remoteProjectPath;
    }

    public String getAccountName() {
        return this.myAccountName;
    }

    @NotNull
    public String getImageName() {
        String string = this.myImageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerCredentialsHolder", "getImageName"));
        }
        return string;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public String getRemoteProjectPath() {
        return this.myRemoteProjectPath;
    }

    public void setAccountName(String accountName) {
        this.myAccountName = accountName;
    }

    public void setImageName(@NotNull String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/intellij/docker/remote/DockerCredentialsHolder", "setImageName"));
        }
        this.myImageName = imageName;
    }

    public void setContainerName(String containerName) {
        this.myContainerName = containerName;
    }

    public void setRemoteProjectPath(String remoteProjectPath) {
        this.myRemoteProjectPath = remoteProjectPath;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/remote/DockerCredentialsHolder", "save"));
        }
        if (this.myAccountName != null) {
            element.setAttribute(DOCKER_ACCOUNT_NAME, this.myAccountName);
        }
        element.setAttribute(DOCKER_IMAGE_NAME, this.myImageName);
        if (this.myContainerName != null) {
            element.setAttribute(DOCKER_CONTAINER_NAME, this.myContainerName);
        }
        if (this.myRemoteProjectPath != null) {
            element.setAttribute(DOCKER_REMOTE_PROJECT_PATH, this.myRemoteProjectPath);
        }
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/remote/DockerCredentialsHolder", "load"));
        }
        this.myAccountName = element.getAttributeValue(DOCKER_ACCOUNT_NAME);
        this.myImageName = StringUtil.notNullize((String)element.getAttributeValue(DOCKER_IMAGE_NAME));
        this.myContainerName = element.getAttributeValue(DOCKER_CONTAINER_NAME);
        this.myRemoteProjectPath = element.getAttributeValue(DOCKER_REMOTE_PROJECT_PATH);
    }

    @Nullable
    public static DockerCredentialsHolder tryGetDockerCredentials(@Nullable RemoteSdkAdditionalData data) {
        if (data == null) {
            return null;
        }
        final Ref ref = Ref.create();
        data.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                ref.set((Object)credentials);
            }
        }});
        return (DockerCredentialsHolder)ref.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerCredentialsHolder holder = (DockerCredentialsHolder)o;
        if (this.myAccountName != null ? !this.myAccountName.equals(holder.myAccountName) : holder.myAccountName != null) {
            return false;
        }
        if (!this.myImageName.equals(holder.myImageName)) {
            return false;
        }
        if (this.myContainerName != null ? !this.myContainerName.equals(holder.myContainerName) : holder.myContainerName != null) {
            return false;
        }
        return !(this.myRemoteProjectPath != null ? !this.myRemoteProjectPath.equals(holder.myRemoteProjectPath) : holder.myRemoteProjectPath != null);
    }

    public int hashCode() {
        int result = this.myAccountName != null ? this.myAccountName.hashCode() : 0;
        result = 31 * result + this.myImageName.hashCode();
        result = 31 * result + (this.myContainerName != null ? this.myContainerName.hashCode() : 0);
        result = 31 * result + (this.myRemoteProjectPath != null ? this.myRemoteProjectPath.hashCode() : 0);
        return result;
    }
}

