/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PortsBuilder {
    @NotNull
    private final ImmutableList.Builder<Integer> myExposedPorts = ImmutableList.builder();
    @NotNull
    private final ImmutableList.Builder<DockerPortBinding> myPortBinding = ImmutableList.builder();

    private PortsBuilder() {
    }

    @NotNull
    public static PortsBuilder builder() {
        PortsBuilder portsBuilder = new PortsBuilder();
        if (portsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PortsBuilder", "builder"));
        }
        return portsBuilder;
    }

    @NotNull
    public PortsBuilder addPortBinding(int containerPort, int hostPort) {
        DockerPortBindingImpl binding = new DockerPortBindingImpl();
        binding.setContainerPort(containerPort);
        binding.setHostPort(Integer.valueOf(hostPort));
        this.myPortBinding.add((Object)binding);
        this.myExposedPorts.add((Object)containerPort);
        PortsBuilder portsBuilder = this;
        if (portsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PortsBuilder", "addPortBinding"));
        }
        return portsBuilder;
    }

    @NotNull
    public PortsBuilder addPortBindings(List<? extends DockerPortBinding> bindings) {
        this.myPortBinding.addAll(bindings);
        this.myExposedPorts.addAll((Iterable)ContainerUtil.map(bindings, DockerPortBinding::getContainerPort));
        PortsBuilder portsBuilder = this;
        if (portsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PortsBuilder", "addPortBindings"));
        }
        return portsBuilder;
    }

    public DockerPortBinding[] buildPortBindings() {
        ImmutableList result = this.myPortBinding.build();
        return (DockerPortBinding[])result.toArray((Object[])new DockerPortBinding[result.size()]);
    }

    @NotNull
    public Integer[] buildExposedPorts() {
        ImmutableList exposedPorts = this.myExposedPorts.build();
        Integer[] integerArray = (Integer[])exposedPorts.toArray((Object[])new Integer[exposedPorts.size()]);
        if (integerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PortsBuilder", "buildExposedPorts"));
        }
        return integerArray;
    }
}

