/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import org.jetbrains.annotations.NotNull;

public class VolumesBuilder {
    private final ImmutableList.Builder<DockerVolumeBinding> myVolumeBindings = ImmutableList.builder();

    private VolumesBuilder() {
    }

    @NotNull
    public static VolumesBuilder builder() {
        VolumesBuilder volumesBuilder = new VolumesBuilder();
        if (volumesBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/VolumesBuilder", "builder"));
        }
        return volumesBuilder;
    }

    @NotNull
    public VolumesBuilder addBoundVolume(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        this.addBoundVolume(path, path);
        VolumesBuilder volumesBuilder = this;
        if (volumesBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        return volumesBuilder;
    }

    @NotNull
    public VolumesBuilder addBoundVolume(@NotNull String path, @NotNull String hostPath) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        if (hostPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPath", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        VolumesBuilder volumesBuilder = this.addBoundVolume(path, hostPath, false);
        if (volumesBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        return volumesBuilder;
    }

    @NotNull
    public VolumesBuilder addBoundVolume(@NotNull String path, @NotNull String hostPath, boolean isReadOnly) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        if (hostPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPath", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        this.myVolumeBindings.add((Object)new DockerVolumeBindingImpl(path, hostPath, isReadOnly));
        VolumesBuilder volumesBuilder = this;
        if (volumesBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolume"));
        }
        return volumesBuilder;
    }

    @NotNull
    public VolumesBuilder addBoundVolumes(@NotNull Iterable<? extends DockerVolumeBinding> bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolumes"));
        }
        this.myVolumeBindings.addAll(bindings);
        VolumesBuilder volumesBuilder = this;
        if (volumesBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/VolumesBuilder", "addBoundVolumes"));
        }
        return volumesBuilder;
    }

    public DockerVolumeBinding[] build() {
        ImmutableList result = this.myVolumeBindings.build();
        return (DockerVolumeBinding[])result.toArray((Object[])new DockerVolumeBinding[result.size()]);
    }
}

