/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.agent.ArrayMapping;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentDeploymentConfigImpl
implements DockerAgentDeploymentConfig {
    private String myImage;
    private DockerVolumeBinding[] myVolumesBinding;
    private String[] myCommand;
    private String myWorkingDir;
    private DockerVolumesFrom[] myVolumesFrom;
    private DockerEnvVar[] myEnvVars;
    private String myContainerName;
    private Boolean myPublishAllPorts;
    private DockerPortBinding[] myPortBindings;
    private Integer[] myExposedPorts;
    private Boolean myNetworkDisabled;
    private String myNetworkMode;
    private DockerLink[] myLinks;
    private String[] myExtraHosts;
    private String myUser;
    private String[] myEntrypoint;
    private DockerLabel[] myLabels;

    public DockerAgentDeploymentConfigImpl(@NotNull String image, @Nullable DockerVolumeBinding[] volumesBinding) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl", "<init>"));
        }
        this.myImage = image;
        this.withVolumeBindings(volumesBinding);
    }

    public String getImageTag() {
        return this.myImage;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public DockerAgentDeploymentConfigImpl withContainerName(String containerName) {
        this.myContainerName = containerName;
        return this;
    }

    public String getJSON() {
        return null;
    }

    public String sourceType() {
        return DockerAgentSourceType.IMAGE.name();
    }

    public boolean isBuildImageOnly() {
        return false;
    }

    public boolean isFileArchive() {
        return false;
    }

    public boolean isCreateContainerOnly() {
        return true;
    }

    public String getUser() {
        return this.myUser;
    }

    public DockerAgentDeploymentConfigImpl withUser(String user) {
        this.myUser = user;
        return this;
    }

    public DockerLabel[] getLabels() {
        return this.myLabels;
    }

    public DockerAgentDeploymentConfigImpl withLabels(DockerLabel[] labels) {
        this.myLabels = labels;
        return this;
    }

    public String getDeploymentName() {
        return null;
    }

    public File getFile() {
        return null;
    }

    public DockerPortBinding[] getPortBindings() {
        return this.myPortBindings;
    }

    public DockerAgentDeploymentConfigImpl withPortBindings(DockerPortBinding[] portBindings) {
        this.myPortBindings = portBindings;
        return this;
    }

    public Boolean getPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public DockerAgentDeploymentConfigImpl withPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
        return this;
    }

    public boolean isPublishAllPorts() {
        return false;
    }

    public DockerAgentDeploymentConfigImpl withExposedPorts(Integer[] exposedPorts) {
        this.myExposedPorts = exposedPorts;
        return this;
    }

    public Integer[] getExposedPorts() {
        return this.myExposedPorts;
    }

    public DockerLink[] getLinks() {
        return this.myLinks;
    }

    public DockerAgentDeploymentConfigImpl withLinks(List<? extends DockerLink> links) {
        this.myLinks = links.toArray(new DockerLink[links.size()]);
        return this;
    }

    public DockerVolumeBinding[] getVolumeBindings() {
        return this.myVolumesBinding;
    }

    public DockerAgentDeploymentConfigImpl withVolumeBindings(DockerVolumeBinding[] volumesBinding) {
        this.myVolumesBinding = (DockerVolumeBinding[])new ArrayMapping<DockerVolumeBinding, DockerVolumeBinding>(){

            protected DockerVolumeBinding mapElement(DockerVolumeBinding source) {
                DockerVolumeBindingImpl result = new DockerVolumeBindingImpl(source);
                result.setHostPath(DockerUtil.toUnixPath(source.getHostPath()));
                return result;
            }
        }.map((Object[])volumesBinding, DockerVolumeBinding.class);
        return this;
    }

    public DockerEnvVar[] getEnvVars() {
        return this.myEnvVars;
    }

    @NotNull
    private static DockerEnvVar[] createEnvArray(@NotNull Map<String, String> env, boolean passParentEnvironment) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl", "createEnvArray"));
        }
        ArrayList<DockerEnvVarImpl> result = new ArrayList<DockerEnvVarImpl>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey();
            if (passParentEnvironment && "PATH".equalsIgnoreCase(key)) {
                value = value + ":$PATH";
            }
            DockerEnvVarImpl envVar = new DockerEnvVarImpl();
            envVar.setName(key);
            envVar.setValue(value);
            result.add(envVar);
        }
        DockerEnvVar[] dockerEnvVarArray = result.toArray(new DockerEnvVar[result.size()]);
        if (dockerEnvVarArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl", "createEnvArray"));
        }
        return dockerEnvVarArray;
    }

    public DockerAgentDeploymentConfigImpl withEnvs(Map<String, String> envs) {
        this.myEnvVars = DockerAgentDeploymentConfigImpl.createEnvArray(envs, true);
        return this;
    }

    public DockerAgentDeploymentConfigImpl withEnvs(@Nullable DockerEnvVar[] envVars) {
        this.myEnvVars = envVars;
        return this;
    }

    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    public DockerAgentDeploymentConfigImpl withEntrypoint(String ... entrypoint) {
        this.myEntrypoint = entrypoint;
        return this;
    }

    public String[] getCommand() {
        return this.myCommand;
    }

    public DockerAgentDeploymentConfigImpl withCommand(String ... command) {
        this.myCommand = command;
        return this;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public DockerAgentDeploymentConfigImpl withWorkingDir(String workingDir) {
        this.myWorkingDir = workingDir;
        return this;
    }

    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    public DockerAgentDeploymentConfigImpl withVolumesFrom(DockerVolumesFrom ... volumesFrom) {
        this.myVolumesFrom = volumesFrom;
        return this;
    }

    public Boolean getNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public DockerAgentDeploymentConfigImpl withNetworkDisabled(boolean networkDisabled) {
        this.myNetworkDisabled = networkDisabled;
        return this;
    }

    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public DockerAgentDeploymentConfigImpl withNetworkMode(String networkMode) {
        this.myNetworkMode = networkMode;
        return this;
    }

    public String[] getExtraHosts() {
        return this.myExtraHosts;
    }

    public DockerAgentDeploymentConfigImpl withExtraHosts(String[] extraHosts) {
        this.myExtraHosts = extraHosts;
        return this;
    }
}

