/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerUtil {
    public static final String JETBRAINS_HELPERS_LABEL = "com.jetbrains.docker.helper.image";
    private static final Pattern CANNOT_START_CONTAINER_PATTERN = Pattern.compile("(?s)Cannot start container [^:]+: \\[8\\] (.*)");
    public static final NotificationGroup NOTIFICATIONS = NotificationGroup.balloonGroup((String)"Docker");
    private static final Logger LOG = Logger.getInstance(DockerUtil.class);
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String TCP_PROTOCOL_PREFIX = "tcp://";
    private static final String UNIX_URL_SCHEME = "unix";
    private static final String DEFAULT_IP_FOR_UNIX_URL_SCHEME = "127.0.0.1";
    public static final String PYCHARM_HELPERS_IMAGE_REPOSITORY = "pycharm_helpers";

    private DockerUtil() {
    }

    @NotNull
    public static String toUnixPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/docker/remote/run/runtime/DockerUtil", "toUnixPath"));
        }
        if (SystemInfo.isWindows) {
            if ((path = path.replaceAll("\\\\", "/")).length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                String string = "/" + path.substring(0, 1).toLowerCase() + path.substring(2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "toUnixPath"));
                }
                return string;
            }
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "toUnixPath"));
            }
            return string;
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "toUnixPath"));
        }
        return string;
    }

    @NotNull
    public static String toHostPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/docker/remote/run/runtime/DockerUtil", "toHostPath"));
        }
        if (SystemInfo.isWindows && path.length() > 2 && '/' == path.charAt(0) && '/' == path.charAt(2) && Character.isLetter(path.charAt(1))) {
            String string = FileUtil.toSystemDependentName((String)(Character.toUpperCase(path.charAt(1)) + ":\\" + path.substring(3)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "toHostPath"));
            }
            return string;
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "toHostPath"));
        }
        return string;
    }

    public static boolean isNoSuchImageCause(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/docker/remote/run/runtime/DockerUtil", "isNoSuchImageCause"));
        }
        return message.contains("No such image:");
    }

    public static boolean isNoSuchFileCause(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/docker/remote/run/runtime/DockerUtil", "isNoSuchFileCause"));
        }
        return message.contains("System error: exec:") && message.contains("no such file or directory");
    }

    public static boolean isAbsentInPathCause(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/docker/remote/run/runtime/DockerUtil", "isAbsentInPathCause"));
        }
        return message.contains("System error: exec:") && message.contains("executable file not found in $PATH");
    }

    public static boolean isCanNotRetrieveImageIdCause(@Nullable String message) {
        return "Can't retrieve image ID from build stream".equals(message);
    }

    @NotNull
    public static RemoteSdkException propagateNotFoundException(@NotNull ServerRuntimeException e, @NotNull String imageName) throws RemoteSdkException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/remote/run/runtime/DockerUtil", "propagateNotFoundException"));
        }
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/intellij/docker/remote/run/runtime/DockerUtil", "propagateNotFoundException"));
        }
        if (DockerUtil.isNoSuchImageCause(e.getMessage())) {
            throw new RemoteSdkException("Docker image \"" + imageName + "\" could not be not found", (Throwable)e);
        }
        String ending = DockerUtil.removeCannotStartContainerPrefix(e.getMessage());
        if (ending == null) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        throw new RemoteSdkException(ending, (Throwable)e);
    }

    @NotNull
    public static RemoteSdkException propagateInternalServerErrorException(@NotNull ServerRuntimeException e) throws RemoteSdkException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/remote/run/runtime/DockerUtil", "propagateInternalServerErrorException"));
        }
        String ending = DockerUtil.removeCannotStartContainerPrefix(e.getMessage());
        if (ending != null) {
            throw new RemoteSdkException(ending, (Throwable)e);
        }
        throw new RemoteSdkException(e.getMessage(), (Throwable)e);
    }

    @NotNull
    public static RemoteSdkException propagateRemoteSdkException(@NotNull Throwable e) throws RemoteSdkException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/remote/run/runtime/DockerUtil", "propagateRemoteSdkException"));
        }
        throw new RemoteSdkException(e.getMessage(), e);
    }

    @NotNull
    public static <R extends RuntimeException, E extends Exception> R propagateRuntimeExceptionCause(@NotNull R e, @NotNull Class<E> cause) throws E {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/remote/run/runtime/DockerUtil", "propagateRuntimeExceptionCause"));
        }
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/docker/remote/run/runtime/DockerUtil", "propagateRuntimeExceptionCause"));
        }
        if (e.getCause() != null && cause.isAssignableFrom(e.getCause().getClass())) {
            throw (Exception)e.getCause();
        }
        throw e;
    }

    @Nullable
    private static String removeCannotStartContainerPrefix(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/docker/remote/run/runtime/DockerUtil", "removeCannotStartContainerPrefix"));
        }
        Matcher matcher = CANNOT_START_CONTAINER_PATTERN.matcher(message);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isUnixSocket(@NotNull DockerCloudConfiguration account) throws RemoteSdkException {
        if (account == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "account", "com/intellij/docker/remote/run/runtime/DockerUtil", "isUnixSocket"));
        }
        return DockerUtil.isUnixSocket(DockerUtil.getDockerApiUri(account));
    }

    private static boolean isUnixSocket(@NotNull URI dockerApiUri) {
        if (dockerApiUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerApiUri", "com/intellij/docker/remote/run/runtime/DockerUtil", "isUnixSocket"));
        }
        return UNIX_URL_SCHEME.equals(dockerApiUri.getScheme());
    }

    private static URI getDockerApiUri(@NotNull DockerCloudConfiguration account) throws RemoteSdkException {
        if (account == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "account", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerApiUri"));
        }
        try {
            return new URI(account.getApiUrl());
        }
        catch (URISyntaxException e) {
            throw DockerUtil.propagateRemoteSdkException(e);
        }
    }

    public static String getDockerHost(@NotNull DockerCloudConfiguration account) throws RemoteSdkException {
        if (account == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "account", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerHost"));
        }
        return DockerUtil.getDockerHost(DockerUtil.getDockerApiUri(account));
    }

    @NotNull
    public static String getDockerHost(URI dockerApiUri) {
        if (DockerUtil.isUnixSocket(dockerApiUri)) {
            if (DEFAULT_IP_FOR_UNIX_URL_SCHEME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerHost"));
            }
            return DEFAULT_IP_FOR_UNIX_URL_SCHEME;
        }
        String string = dockerApiUri.getHost();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerHost"));
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    private static String getDockerHost(@Nullable String url) {
        if (url == null) {
            return null;
        }
        for (String prefix : new String[]{HTTP_PROTOCOL_PREFIX, HTTPS_PROTOCOL_PREFIX}) {
            if (!url.startsWith(prefix)) continue;
            return TCP_PROTOCOL_PREFIX + url.substring(prefix.length());
        }
        return url;
    }

    private static boolean isTlsVerifyEnabled(@Nullable String url) {
        return url != null && url.startsWith(HTTPS_PROTOCOL_PREFIX);
    }

    public static List<String[]> getNotTemplateImages(@NotNull DockerCloudConfiguration account) throws ServerRuntimeException {
        if (account == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "account", "com/intellij/docker/remote/run/runtime/DockerUtil", "getNotTemplateImages"));
        }
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create(account, null);
        Set helpers = Arrays.stream(dockerRuntime.getImages(JETBRAINS_HELPERS_LABEL)).map(DockerAgentApplication::getImageId).collect(Collectors.toSet());
        return Arrays.stream(dockerRuntime.getImages()).filter(image -> !helpers.contains(image.getImageId()) && !DockerUtil.isOldStyleHelperImage(image)).map(DockerAgentApplication::getImageRepoTags).collect(Collectors.toList());
    }

    private static boolean isOldStyleHelperImage(@NotNull DockerAgentApplication image) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/docker/remote/run/runtime/DockerUtil", "isOldStyleHelperImage"));
        }
        for (String tag : image.getImageRepoTags()) {
            if (!tag.startsWith("pycharm_helpers:")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getDockerHost(@NotNull RemoteSdkAdditionalData remoteSdkAdditionalData) {
        if (remoteSdkAdditionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkAdditionalData", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerHost"));
        }
        final Ref serverHostRef = Ref.create();
        remoteSdkAdditionalData.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                serverHostRef.set((Object)DockerUtil.getDockerHostForAccount(credentials.getAccountName()));
            }
        }, new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                serverHostRef.set((Object)DockerUtil.getDockerHostForAccount(credentials.getAccountName()));
            }
        }});
        if (serverHostRef.isNull()) {
            throw new IllegalArgumentException("Remote SDK has neither Docker nor Docker Compose type");
        }
        String string = (String)serverHostRef.get();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerHost"));
        }
        return string;
    }

    @NotNull
    private static String getDockerHostForAccount(@Nullable String accountName) {
        String string;
        if (accountName == null) {
            throw new IllegalStateException("Docker account is not specified");
        }
        RemoteServer dockerServer = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (dockerServer == null) {
            throw new IllegalStateException("Docker account " + accountName + " does not exist");
        }
        try {
            URI uri = new URI(((DockerCloudConfiguration)dockerServer.getConfiguration()).getApiUrl());
            string = UNIX_URL_SCHEME.equals(uri.getScheme()) ? DEFAULT_IP_FOR_UNIX_URL_SCHEME : uri.getHost();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to parse Docker API URL of the Docker account " + accountName, e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerUtil", "getDockerHostForAccount"));
        }
        return string;
    }
}

