/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.xpath.XPathTokenTypes;

public class XPathStringLiteralSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        ASTNode astNode = e.getNode();
        return astNode != null && astNode.getElementType() == XPathTokenTypes.STRING_LITERAL;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        TextRange elem = e.getTextRange();
        if (elem.getLength() > 2) {
            return new SmartList((Object)new TextRange(elem.getStartOffset() + 1, elem.getEndOffset() - 1));
        }
        return Collections.emptyList();
    }
}

