/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import org.intellij.lang.xpath.psi.XPath2ElementVisitor;
import org.intellij.lang.xpath.psi.XPath2Sequence;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPath2ElementImpl;
import org.jetbrains.annotations.NotNull;

public class XPath2SequenceImpl
extends XPath2ElementImpl
implements XPath2Sequence {
    public XPath2SequenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathExpression[] getSequence() {
        XPathExpression[] xPathExpressionArray = (XPathExpression[])this.findChildrenByClass(XPathExpression.class);
        if (xPathExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2SequenceImpl", "getSequence"));
        }
        return xPathExpressionArray;
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathExpression[] sequence = this.getSequence();
        if (sequence.length == 0) {
            XPath2Type xPath2Type = XPath2Type.SEQUENCE;
            if (xPath2Type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2SequenceImpl", "getType"));
            }
            return xPath2Type;
        }
        XPathType commonType = XPath2Type.mapType(sequence[0].getType());
        block0: while (commonType != null) {
            for (int i = 1; i < sequence.length; ++i) {
                XPathType t = XPath2Type.mapType(sequence[i].getType());
                if (commonType.isAssignableFrom(t)) break block0;
            }
            commonType = XPathType.getSuperType(commonType);
        }
        if (commonType != null) {
            XPath2Type xPath2Type = XPath2SequenceType.create(commonType, XPath2SequenceType.Cardinality.ONE_OR_MORE);
            if (xPath2Type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2SequenceImpl", "getType"));
            }
            return xPath2Type;
        }
        XPathType xPathType = XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2SequenceImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    public void accept(XPath2ElementVisitor visitor) {
        visitor.visitXPath2Sequence(this);
    }
}

