/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.quickfix.ReplaceElementFix;
import org.jetbrains.annotations.NotNull;

public class MakeTypeExplicitFix
extends ReplaceElementFix<XPathExpression> {
    private final XPathType myType;

    public MakeTypeExplicitFix(XPathExpression expression, XPathType type) {
        super(expression);
        this.myType = type;
    }

    @NotNull
    public String getText() {
        if ("Make Type Conversion Explicit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/quickfix/MakeTypeExplicitFix", "getText"));
        }
        return "Make Type Conversion Explicit";
    }

    @NotNull
    public String getFamilyName() {
        if ("ImplicitTypeConversion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/quickfix/MakeTypeExplicitFix", "getFamilyName"));
        }
        return "ImplicitTypeConversion";
    }

    @Override
    public void invokeImpl(Project project, PsiFile file) throws IncorrectOperationException {
        XPathExpression myElement = (XPathExpression)this.getStartElement();
        if (this.myType == XPathType.BOOLEAN) {
            if (myElement.getType() == XPathType.STRING) {
                String text;
                if (ExpectedTypeUtil.isExplicitConversion(myElement)) {
                    XPathExpression expr = ExpectedTypeUtil.unparenthesize(myElement);
                    assert (expr != null);
                    text = ((XPathFunctionCall)expr).getArgumentList()[0].getText();
                } else {
                    text = myElement.getText();
                }
                this.replace("string-length(" + text + ") > 0");
                return;
            }
            if (myElement.getType() == XPathType.NODESET) {
                this.replace("count(" + myElement.getText() + ") > 0");
                return;
            }
        }
        this.replace(this.myType.getName() + "(" + myElement.getText() + ")");
    }
}

