/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.net.IOExceptionDialog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.quickfix.DownloadManager;
import org.jetbrains.annotations.NotNull;

public class DownloadResourceFix
implements LocalQuickFix {
    private final String myLocation;

    public DownloadResourceFix(String location) {
        this.myLocation = location;
    }

    @NotNull
    public String getFamilyName() {
        if ("Download External Resource" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/DownloadResourceFix", "getFamilyName"));
        }
        return "Download External Resource";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/DownloadResourceFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/lang/xpath/xslt/quickfix/DownloadResourceFix", "applyFix"));
        }
        boolean tryAgain = true;
        DownloadManager.DownloadException[] ex = new DownloadManager.DownloadException[1];
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/DownloadResourceFix", "lambda$applyFix$0"));
            }
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            MyDownloadManager downloadManager = new MyDownloadManager(project, progress);
            try {
                downloadManager.fetch(this.myLocation);
            }
            catch (DownloadManager.DownloadException e) {
                ex[0] = e;
            }
        };
        while (tryAgain) {
            tryAgain = false;
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, "Downloading Resource", true, project)) continue;
            if (ex[0] == null) break;
            tryAgain = IOExceptionDialog.showErrorDialog((String)"Error during Download", (String)("Error downloading " + ex[0].getLocation()));
            ex[0] = null;
        }
    }

    private static class MyDownloadManager
    extends DownloadManager {
        public MyDownloadManager(Project project, ProgressIndicator progress) {
            super(project, progress);
        }

        private static void processReferences(XmlTag[] subTags, Set<String> list) {
            for (XmlTag xmlTag : subTags) {
                String href = xmlTag.getAttributeValue("href");
                if (href == null || !href.startsWith("http://")) continue;
                list.add(href);
            }
        }

        @Override
        protected boolean isAccepted(PsiFile psiFile) {
            return XsltSupport.isXsltFile(psiFile);
        }

        @Override
        protected Set<String> getResourceDependencies(PsiFile psiFile) {
            XmlTag rootTag;
            XmlDocument document = ((XmlFile)psiFile).getDocument();
            if (document != null && (rootTag = document.getRootTag()) != null) {
                HashSet<String> list = new HashSet<String>();
                MyDownloadManager.processReferences(rootTag.findSubTags("include", "http://www.w3.org/1999/XSL/Transform"), list);
                MyDownloadManager.processReferences(rootTag.findSubTags("import", "http://www.w3.org/1999/XSL/Transform"), list);
                return list;
            }
            return Collections.emptySet();
        }
    }
}

