/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.support.jaxen.PsiDocumentNavigator;
import org.intellij.plugins.xpathView.util.MyPsiUtil;
import org.intellij.plugins.xpathView.util.Namespace;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jetbrains.annotations.Nullable;

public class XPathExpressionGenerator {
    private static final XPathSupport xpathSupport = XPathSupport.getInstance();

    private XPathExpressionGenerator() {
    }

    public static String getUniquePath(XmlElement element, XmlTag context) {
        PathVisitor visitor = new PathVisitor(context);
        element.accept((PsiElementVisitor)visitor);
        return visitor.getUniquePath();
    }

    public static String getPath(XmlElement element, XmlTag context) {
        PathVisitor visitor = new PathVisitor(context);
        element.accept((PsiElementVisitor)visitor);
        return visitor.getPath();
    }

    @Nullable
    public static PsiElement transformToValidShowPathNode(PsiElement contextNode) {
        for (PsiElement element = contextNode; element != null; element = element.getParent()) {
            if (MyPsiUtil.isNameElement(element)) {
                return element.getParent();
            }
            if (MyPsiUtil.isStartTag(contextNode) || MyPsiUtil.isEndTag(contextNode)) {
                return element.getParent();
            }
            if (element instanceof XmlAttribute) {
                return element;
            }
            if (element instanceof XmlComment) {
                return element;
            }
            if (element instanceof XmlProcessingInstruction) {
                return element;
            }
            if (!(element instanceof XmlText)) continue;
            return element;
        }
        return null;
    }

    private static class PathVisitor
    extends XmlElementVisitor {
        private final XmlTag context;
        private final Map<String, String> usedPrefixes = new HashMap<String, String>();
        private String uniquePath;
        private String path;

        public PathVisitor(XmlTag context) {
            this.context = context;
        }

        @Nullable
        private String getXPathNameStep(XmlTag tag) {
            String prefix;
            String uri = tag.getNamespace();
            if (uri.length() == 0) {
                return tag.getName();
            }
            if (MyPsiUtil.isInDeclaredNamespace(tag, uri, tag.getNamespacePrefix()) && (prefix = tag.getNamespacePrefix()).length() == 0) {
                String guessedPrefix = this.guessPrefix(tag);
                return guessedPrefix != null ? guessedPrefix + ":" + tag.getLocalName() : "*[name()='" + tag.getName() + "']";
            }
            return tag.getName();
        }

        @Nullable
        private String guessPrefix(XmlTag tag) {
            String prefix = this.usedPrefixes.get(tag.getNamespace());
            if (prefix != null) {
                return prefix;
            }
            return this.tryUseUri(tag);
        }

        @Nullable
        private String tryUseUri(XmlTag context) {
            String segment = PathVisitor.chooseSegment(context.getNamespace());
            if (segment == null) {
                return null;
            }
            if (segment.length() <= 3 && this.tryUsePrefix(segment, context)) {
                return segment;
            }
            for (int i = 1; i <= segment.length(); ++i) {
                String prefix = segment.substring(0, i);
                if (!this.tryUsePrefix(prefix, context)) continue;
                return prefix;
            }
            return null;
        }

        private boolean tryUsePrefix(String prefix, XmlTag context) {
            if (!this.prefixOk(prefix, context)) {
                return false;
            }
            this.usePrefix(prefix, context.getNamespace());
            return true;
        }

        private boolean prefixOk(String prefix, XmlTag context) {
            String ns;
            String namespace = context.getNamespace();
            if (!this.usedPrefixes.containsKey(prefix) && ((ns = context.getNamespaceByPrefix(prefix)).length() == 0 || ns.equals(namespace))) {
                return true;
            }
            return namespace.equals(this.usedPrefixes.get(prefix));
        }

        private void usePrefix(String prefix, String namespace) {
            this.usedPrefixes.put(prefix, namespace);
        }

        private static String chooseSegment(String ns) {
            String segment;
            int i;
            int off = ns.indexOf(35);
            if (off >= 0) {
                String segment2 = ns.substring(off + 1).toLowerCase();
                if (PathVisitor.isValidPrefix(segment2)) {
                    return segment2;
                }
            } else {
                off = ns.length();
            }
            while ((i = ns.lastIndexOf(47, off - 1)) >= 0 && (i <= 0 || ns.charAt(i - 1) != '/')) {
                String segment3 = ns.substring(i + 1, off).toLowerCase();
                if (PathVisitor.segmentOk(segment3)) {
                    return segment3;
                }
                off = i;
            }
            off = ns.indexOf(58);
            if (off >= 0 && PathVisitor.segmentOk(segment = ns.substring(off + 1).toLowerCase())) {
                return segment;
            }
            return null;
        }

        private static boolean isValidPrefix(String segment) {
            return segment.matches("\\p{Alpha}\\p{Alnum}*");
        }

        private static boolean segmentOk(String segment) {
            return PathVisitor.isValidPrefix(segment) && !segment.equals("ns") && !segment.equals("namespace");
        }

        public void visitElement(PsiElement element) {
            if (element instanceof XmlProcessingInstruction) {
                this.visitProcessingInstruction((XmlProcessingInstruction)element);
            } else {
                super.visitElement(element);
            }
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            this.uniquePath = this.getUniquePath(attribute);
            this.path = this.getPath(attribute);
        }

        public String getPath(XmlAttribute attribute) {
            StringBuilder result = new StringBuilder();
            XmlTag parent = attribute.getParent();
            if (parent != null && parent != this.context) {
                result.append(this.getPath(parent));
                result.append("/");
            }
            result.append("@");
            String uri = attribute.getNamespace();
            String prefix = MyPsiUtil.getAttributePrefix(attribute);
            if (uri.length() == 0 || prefix == null || prefix.length() == 0) {
                result.append(attribute.getLocalName());
            } else {
                result.append(attribute.getName());
            }
            return result.toString();
        }

        public String getUniquePath(XmlAttribute attribute) {
            StringBuilder result = new StringBuilder();
            XmlTag parent = attribute.getParent();
            if (parent != null && parent != this.context) {
                result.append(this.getUniquePath(parent));
                result.append("/");
            }
            result.append("@");
            String uri = attribute.getNamespace();
            String prefix = MyPsiUtil.getAttributePrefix(attribute);
            if (uri.length() == 0 || prefix == null || prefix.length() == 0) {
                result.append(attribute.getLocalName());
            } else {
                result.append(attribute.getName());
            }
            return result.toString();
        }

        public void visitXmlTag(XmlTag tag) {
            this.uniquePath = this.getUniquePath(tag);
            this.path = this.getPath(tag);
        }

        private String getUniquePath(XmlTag tag) {
            XmlTag parent = tag.getParentTag();
            if (parent == null) {
                return "/" + this.getXPathNameStep(tag);
            }
            StringBuilder buffer = new StringBuilder();
            if (parent != this.context) {
                buffer.append(this.getUniquePath(parent));
                buffer.append("/");
            }
            buffer.append(this.getXPathNameStep(tag));
            return this.makeUnique(buffer.toString(), (XmlElement)tag);
        }

        @Nullable
        public String getPath(XmlTag tag) {
            if (tag == this.context) {
                return ".";
            }
            XmlTag parent = tag.getParentTag();
            if (parent == null) {
                return "/" + this.getXPathNameStep(tag);
            }
            if (parent == this.context) {
                return this.getXPathNameStep(tag);
            }
            return this.getPath(parent) + "/" + this.getXPathNameStep(tag);
        }

        public void visitXmlComment(XmlComment comment) {
            this.uniquePath = this.getUniquePath(comment);
            this.path = this.getPath(comment);
        }

        public String getPath(XmlComment comment) {
            XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)comment, XmlTag.class);
            return parent != null && parent != this.context ? this.getPath(parent) + "/comment()" : "comment()";
        }

        public String getUniquePath(XmlComment comment) {
            XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)comment, XmlTag.class);
            return this.makeUnique(parent != null && parent != this.context ? this.getUniquePath(parent) + "/comment()" : "comment()", (XmlElement)comment);
        }

        public void visitXmlText(XmlText text) {
            this.uniquePath = this.getUniquePath(text);
            this.path = this.getPath(text);
        }

        public String getPath(XmlText text) {
            XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)text, XmlTag.class);
            return parent != null && parent != this.context ? this.getPath(parent) + "/text()" : "text()";
        }

        public String getUniquePath(XmlText text) {
            XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)text, XmlTag.class);
            return this.makeUnique(parent != null && parent != this.context ? this.getUniquePath(parent) + "/text()" : "text()", (XmlElement)text);
        }

        protected void visitProcessingInstruction(XmlProcessingInstruction processingInstruction) {
            this.uniquePath = this.getUniquePath(processingInstruction);
            this.path = this.getPath(processingInstruction);
        }

        public String getPath(XmlProcessingInstruction processingInstruction) {
            XmlTag parent = processingInstruction.getParentTag();
            return parent != null && parent != this.context ? this.getPath(parent) + "/processing-instruction()" : "processing-instruction()";
        }

        public String getUniquePath(XmlProcessingInstruction processingInstruction) {
            XmlTag parent = processingInstruction.getParentTag();
            String target = PsiDocumentNavigator.getProcessingInstructionTarget(processingInstruction);
            String s = target != null ? "'" + target + "'" : "";
            return this.makeUnique(parent != null && parent != this.context ? this.getUniquePath(parent) + "/processing-instruction(" + s + ")" : "processing-instruction(" + s + ")", (XmlElement)processingInstruction);
        }

        public String getUniquePath() {
            return this.uniquePath;
        }

        public String getPath() {
            return this.path;
        }

        String makeUnique(String uniquePath, XmlElement what) {
            XmlFile file = (XmlFile)what.getContainingFile();
            assert (file != null);
            try {
                XPath xPath = xpathSupport.createXPath(file, uniquePath, Namespace.fromMap(this.usedPrefixes));
                Object o = xPath.evaluate((Object)file.getDocument());
                if (o instanceof List) {
                    List list = (List)o;
                    if (list.size() > 1) {
                        XmlTag tag;
                        XmlAttribute[] attributes;
                        if (what instanceof XmlTag && (attributes = (tag = (XmlTag)what).getAttributes()).length > 0) {
                            for (XmlAttribute attribute : attributes) {
                                String name = attribute.getName();
                                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                                if ((attribute.getValue() == null || descriptor == null || !descriptor.hasIdType()) && !name.equalsIgnoreCase("id") && !name.equalsIgnoreCase("name")) continue;
                                StringBuilder buffer = new StringBuilder(uniquePath);
                                buffer.append("[@");
                                buffer.append(name);
                                buffer.append("='");
                                buffer.append(attribute.getValue());
                                buffer.append("']");
                                return buffer.toString();
                            }
                        }
                        int i = 1;
                        for (Object o1 : list) {
                            if (o1 == what) {
                                return uniquePath + "[" + i + "]";
                            }
                            ++i;
                        }
                        assert (false) : "Expression " + uniquePath + " didn't find input element " + what;
                    }
                } else assert (false) : "Unknown return value: " + o;
            }
            catch (JaxenException e) {
                Logger.getInstance((String)"XPathExpressionGenerator").error((Throwable)e);
            }
            return uniquePath;
        }
    }
}

