/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.search;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.search.FindFormPanel;
import org.intellij.plugins.xpathView.search.SearchScope;
import org.intellij.plugins.xpathView.ui.InputExpressionDialog;
import org.intellij.plugins.xpathView.ui.Mode;
import org.jetbrains.annotations.NotNull;

public class FindByExpressionDialog
extends InputExpressionDialog<FindFormPanel> {
    public FindByExpressionDialog(Project parent, Config settings, HistoryElement[] history, Module module) {
        super(parent, settings, history, new FindFormPanel(parent, module, settings.SEARCH_SCOPE));
        this.setTitle("Find by XPath Expression");
        this.setOKButtonText(FindBundle.message((String)"find.button", (Object[])new Object[0]));
    }

    @Override
    protected void init() {
        ToolWindow findWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.FIND);
        boolean available = findWindow != null && findWindow.isAvailable();
        ((FindFormPanel)this.myForm).getNewTabCheckbox().setEnabled(available);
        ((FindFormPanel)this.myForm).getNewTabCheckbox().setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        ((FindFormPanel)this.myForm).getScopePanel().addPropertyChangeListener("scope", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FindByExpressionDialog.this.updateOkAction();
            }
        });
        ((FindFormPanel)this.myForm).getMatchEachNode().setSelected(this.mySettings.MATCH_RECURSIVELY);
        ((FindFormPanel)this.myForm).getMatchRootNode().setSelected(!this.mySettings.MATCH_RECURSIVELY);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myForm);
        super.init();
    }

    @Override
    protected void setModeImpl(Mode mode) {
        ((FindFormPanel)this.myForm).getOptionsPanel().setVisible(mode == Mode.ADVANCED);
        super.setModeImpl(mode);
    }

    @Override
    protected boolean isOkEnabled() {
        return ((FindFormPanel)this.myForm).getScope().isValid() && super.isOkEnabled();
    }

    protected void doOKAction() {
        if (((FindFormPanel)this.myForm).getNewTabCheckbox().isEnabled()) {
            FindSettings.getInstance().setShowResultsInSeparateView(((FindFormPanel)this.myForm).getNewTabCheckbox().isSelected());
        }
        super.doOKAction();
    }

    @Override
    @NotNull
    protected String getPrivateDimensionServiceKey() {
        if ("XPathView.FindDialog.DIMENSION_SERVICE_KEY" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/FindByExpressionDialog", "getPrivateDimensionServiceKey"));
        }
        return "XPathView.FindDialog.DIMENSION_SERVICE_KEY";
    }

    public SearchScope getScope() {
        return ((FindFormPanel)this.myForm).getScopePanel().getSearchScope();
    }

    public boolean isMatchRecursively() {
        return ((FindFormPanel)this.myForm).getMatchEachNode().isSelected();
    }
}

