/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.AbstractVagrantItemManager;
import com.jetbrains.plugins.vagrant.AddVagrantBoxDialog;
import com.jetbrains.plugins.vagrant.VagrantBox;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantBoxManager
extends AbstractVagrantItemManager<VagrantBox> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.Task");
    private static final Pattern PATTERN_PROGRESS = Pattern.compile("Progress: (\\d+)%");

    public VagrantBoxManager(Project project) {
        super(project);
    }

    @Override
    protected VagrantBox createItem(String line) {
        return new VagrantBox(line);
    }

    @Override
    protected String emptyListText() {
        return "There are no installed boxes!";
    }

    @Override
    protected String[] listItemsArguments() {
        return new String[]{"box", "list"};
    }

    @Override
    protected String getItemName() {
        return "Box";
    }

    @NotNull
    public FutureResult<VagrantBox> add(@NotNull String name, @NotNull String url) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/vagrant/VagrantBoxManager", "add"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/plugins/vagrant/VagrantBoxManager", "add"));
        }
        VagrantTask task = this.createTask("box", "add", name, url);
        FutureResult<VagrantBox> futureResult = this.runTask(name, task, "Downloading Vagrant Box");
        if (futureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantBoxManager", "add"));
        }
        return futureResult;
    }

    private FutureResult<VagrantBox> runTask(final String name, final VagrantTask task, String title) {
        final FutureResult futureBox = new FutureResult();
        if (task != null) {
            Task.Backgroundable backgroundableTask = new Task.Backgroundable(this.myProject, title, true, new PerformInBackgroundOption(){

                public void processSentToBackground() {
                }

                public boolean shouldStartInBackground() {
                    return false;
                }
            }){

                public void run(final @NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/vagrant/VagrantBoxManager$2", "run"));
                    }
                    indicator.setFraction(0.0);
                    indicator.isIndeterminate();
                    try {
                        CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(task.createCommandLine());
                        handler.addProcessListener((ProcessListener)new ProcessAdapter((CapturingProcessHandler)handler){
                            final /* synthetic */ CapturingProcessHandler val$handler;
                            {
                                this.val$handler = capturingProcessHandler;
                            }

                            public void onTextAvailable(ProcessEvent event, Key outputType) {
                                Matcher m = PATTERN_PROGRESS.matcher(event.getText());
                                if (m.find()) {
                                    try {
                                        indicator.setFraction((double)Integer.parseInt(m.group(1)) / 100.0);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (indicator.isCanceled()) {
                                    this.val$handler.destroyProcess();
                                }
                            }
                        });
                        ProcessOutput output = handler.runProcess();
                        if (output.getExitCode() != 0) {
                            UIUtil.invokeLaterIfNeeded(() -> {
                                Messages.showErrorDialog((Project)this.myProject, (String)output.getStderr(), (String)"Error Adding Box");
                                futureBox.set(null);
                            });
                        } else {
                            VagrantBoxManager.this.dropCache();
                            futureBox.set((Object)new VagrantBox(name));
                            VagrantBoxManager.this.fireEvent();
                        }
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)("Can't add Vagrant box:" + message), (String)"Error Adding Box"));
                        futureBox.set(null);
                    }
                }
            };
            ProgressManager.getInstance().run((Task)backgroundableTask);
        } else {
            futureBox.set(null);
        }
        return futureBox;
    }

    @Override
    protected String[] removeItemArguments(VagrantItem box) {
        return new String[]{"box", "remove", box.getName()};
    }

    @Override
    @Nullable
    public FutureResult<VagrantBox> add() {
        AddVagrantBoxDialog dialog = new AddVagrantBoxDialog(this.myProject, this.listItems());
        if (dialog.showAndGet()) {
            return this.add(dialog.getName(), dialog.getUrl());
        }
        return null;
    }
}

