/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import com.jetbrains.plugins.vagrant.VagrantService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantManager {
    private final Project myProject;

    public VagrantManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantManager", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantManager", "getProject"));
        }
        return project;
    }

    public static VagrantManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantManager", "getInstance"));
        }
        return (VagrantManager)ServiceManager.getService((Project)project, VagrantManager.class);
    }

    @NotNull
    public List<VagrantInstance> listInstances() {
        ArrayList result = Lists.newArrayList();
        String instanceFolder = this.getInstanceFolder();
        if (!StringUtil.isEmpty((String)instanceFolder)) {
            result.add(VagrantManager.fromFolder(instanceFolder));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantManager", "listInstances"));
        }
        return arrayList;
    }

    @Contract(value="null -> null; !null -> !null")
    private static VagrantInstance fromFolder(@Nullable String folder) {
        if (folder == null) {
            return null;
        }
        return VagrantService.getInstance().getVagrantInstance(folder);
    }

    @Nullable
    public VagrantInstance currentInstance() {
        return VagrantManager.fromFolder(this.getInstanceFolder());
    }

    @Nullable
    public String getVagrantExecutable(boolean askIfNotSet) {
        return VagrantService.getInstance().getVagrantExecutable(this.myProject, askIfNotSet);
    }

    public boolean haveInstance() {
        String instanceFolder = this.getInstanceFolder();
        return !StringUtil.isEmpty((String)instanceFolder);
    }

    @Nullable
    public String getInstanceFolder() {
        VagrantProjectSettings settings = VagrantProjectSettings.getInstance(this.myProject);
        String instanceFolder = settings.getInstanceFolder();
        if (StringUtil.isEmpty((String)instanceFolder)) {
            instanceFolder = this.detectInstanceInCurrentProject();
        }
        return instanceFolder;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        VagrantProjectSettings settings = VagrantProjectSettings.getInstance(this.myProject);
        Map<String, String> map = settings.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantManager", "getEnvs"));
        }
        return map;
    }

    @Nullable
    public String detectInstanceInCurrentProject() {
        for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
            if (!VagrantManager.isVagrantInstance(root)) continue;
            return root.getPath();
        }
        return null;
    }

    private static boolean isVagrantInstance(@NotNull VirtualFile folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/jetbrains/plugins/vagrant/VagrantManager", "isVagrantInstance"));
        }
        return folder.findChild("Vagrantfile") != null;
    }
}

